/* This file is autogenerated by u_format_pack.py from u_format.csv. Do not edit directly. */

/**************************************************************************
 *
 * Copyright 2009 VMware, Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL VMWARE AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 **************************************************************************/

/**
 * @file
 * Pixel format packing and unpacking functions.
 *
 * @author Jose Fonseca <jfonseca@vmware.com>
 */

#ifndef U_FORMAT_PACK_H
#define U_FORMAT_PACK_H

#include "pipe/p_compiler.h"
#include "u_math.h"
#include "u_format.h"

static INLINE double
clamp(double value, double lbound, double ubound)
{
   if(value < lbound)
      return lbound;
   if(value > ubound)
      return ubound;
   return value;
}

static INLINE float
clampf(float value, float lbound, float ubound)
{
   if(value < lbound)
      return lbound;
   if(value > ubound)
      return ubound;
   return value;
}

static INLINE unsigned int
clampui(unsigned int value, unsigned int lbound, unsigned int ubound)
{
   if(value < lbound)
      return lbound;
   if(value > ubound)
      return ubound;
   return value;
}

static INLINE int
clampsi(int value, int lbound, int ubound)
{
   if(value < lbound)
      return lbound;
   if(value > ubound)
      return ubound;
   return value;
}

union util_format_b8g8r8a8_unorm {
   uint32_t value;
   struct {
      uint8_t b;
      uint8_t g;
      uint8_t r;
      uint8_t a;
   } chan;
};

union util_format_b8g8r8x8_unorm {
   uint32_t value;
   struct {
      uint8_t b;
      uint8_t g;
      uint8_t r;
      uint8_t x;
   } chan;
};

union util_format_a8r8g8b8_unorm {
   uint32_t value;
   struct {
      uint8_t a;
      uint8_t r;
      uint8_t g;
      uint8_t b;
   } chan;
};

union util_format_x8r8g8b8_unorm {
   uint32_t value;
   struct {
      uint8_t x;
      uint8_t r;
      uint8_t g;
      uint8_t b;
   } chan;
};

union util_format_a8b8g8r8_unorm {
   uint32_t value;
   struct {
      uint8_t a;
      uint8_t b;
      uint8_t g;
      uint8_t r;
   } chan;
};

union util_format_x8b8g8r8_unorm {
   uint32_t value;
   struct {
      uint8_t x;
      uint8_t b;
      uint8_t g;
      uint8_t r;
   } chan;
};

union util_format_b5g5r5a1_unorm {
   uint16_t value;
   struct {
      unsigned b:5;
      unsigned g:5;
      unsigned r:5;
      unsigned a:1;
   } chan;
};

union util_format_b4g4r4a4_unorm {
   uint16_t value;
   struct {
      unsigned b:4;
      unsigned g:4;
      unsigned r:4;
      unsigned a:4;
   } chan;
};

union util_format_b5g6r5_unorm {
   uint16_t value;
   struct {
      unsigned b:5;
      unsigned g:6;
      unsigned r:5;
   } chan;
};

union util_format_r10g10b10a2_unorm {
   uint32_t value;
   struct {
      unsigned r:10;
      unsigned g:10;
      unsigned b:10;
      unsigned a:2;
   } chan;
};

union util_format_l8_unorm {
   uint8_t value;
   struct {
      uint8_t rgb;
   } chan;
};

union util_format_a8_unorm {
   uint8_t value;
   struct {
      uint8_t a;
   } chan;
};

union util_format_i8_unorm {
   uint8_t value;
   struct {
      uint8_t rgba;
   } chan;
};

union util_format_l8a8_unorm {
   uint16_t value;
   struct {
      uint8_t rgb;
      uint8_t a;
   } chan;
};

union util_format_l16_unorm {
   uint16_t value;
   struct {
      uint16_t rgb;
   } chan;
};

union util_format_l8_srgb {
   uint8_t value;
   struct {
      uint8_t rgb;
   } chan;
};

union util_format_l8a8_srgb {
   uint16_t value;
   struct {
      uint8_t rgb;
      uint8_t a;
   } chan;
};

union util_format_r8g8b8_srgb {
   struct {
      uint8_t r;
      uint8_t g;
      uint8_t b;
   } chan;
};

union util_format_a8b8g8r8_srgb {
   uint32_t value;
   struct {
      uint8_t a;
      uint8_t b;
      uint8_t g;
      uint8_t r;
   } chan;
};

union util_format_x8b8g8r8_srgb {
   uint32_t value;
   struct {
      uint8_t x;
      uint8_t b;
      uint8_t g;
      uint8_t r;
   } chan;
};

union util_format_b8g8r8a8_srgb {
   uint32_t value;
   struct {
      uint8_t b;
      uint8_t g;
      uint8_t r;
      uint8_t a;
   } chan;
};

union util_format_b8g8r8x8_srgb {
   uint32_t value;
   struct {
      uint8_t b;
      uint8_t g;
      uint8_t r;
      uint8_t x;
   } chan;
};

union util_format_a8r8g8b8_srgb {
   uint32_t value;
   struct {
      uint8_t a;
      uint8_t r;
      uint8_t g;
      uint8_t b;
   } chan;
};

union util_format_x8r8g8b8_srgb {
   uint32_t value;
   struct {
      uint8_t x;
      uint8_t r;
      uint8_t g;
      uint8_t b;
   } chan;
};

union util_format_r8sg8sb8ux8u_norm {
   uint32_t value;
   struct {
      int8_t r;
      int8_t g;
      uint8_t b;
      uint8_t x;
   } chan;
};

union util_format_r5sg5sb6u_norm {
   uint16_t value;
   struct {
      int r:5;
      int g:5;
      unsigned b:6;
   } chan;
};

union util_format_s8_unorm {
   uint8_t value;
   struct {
      uint8_t s;
   } chan;
};

union util_format_z16_unorm {
   uint16_t value;
   struct {
      uint16_t z;
   } chan;
};

union util_format_z32_unorm {
   struct {
      uint32_t z;
   } chan;
};

union util_format_z32_float {
   struct {
      float z;
   } chan;
};

union util_format_z24s8_unorm {
   uint32_t value;
   struct {
      unsigned z:24;
      unsigned s:8;
   } chan;
};

union util_format_s8z24_unorm {
   uint32_t value;
   struct {
      unsigned s:8;
      unsigned z:24;
   } chan;
};

union util_format_z24x8_unorm {
   uint32_t value;
   struct {
      unsigned z:24;
      unsigned x:8;
   } chan;
};

union util_format_x8z24_unorm {
   uint32_t value;
   struct {
      unsigned x:8;
      unsigned z:24;
   } chan;
};

union util_format_r64_float {
   struct {
      double r;
   } chan;
};

union util_format_r64g64_float {
   struct {
      double r;
      double g;
   } chan;
};

union util_format_r64g64b64_float {
   struct {
      double r;
      double g;
      double b;
   } chan;
};

union util_format_r64g64b64a64_float {
   struct {
      double r;
      double g;
      double b;
      double a;
   } chan;
};

union util_format_r32_float {
   struct {
      float r;
   } chan;
};

union util_format_r32g32_float {
   struct {
      float r;
      float g;
   } chan;
};

union util_format_r32g32b32_float {
   struct {
      float r;
      float g;
      float b;
   } chan;
};

union util_format_r32g32b32a32_float {
   struct {
      float r;
      float g;
      float b;
      float a;
   } chan;
};

union util_format_r32_unorm {
   struct {
      uint32_t r;
   } chan;
};

union util_format_r32g32_unorm {
   struct {
      uint32_t r;
      uint32_t g;
   } chan;
};

union util_format_r32g32b32_unorm {
   struct {
      uint32_t r;
      uint32_t g;
      uint32_t b;
   } chan;
};

union util_format_r32g32b32a32_unorm {
   struct {
      uint32_t r;
      uint32_t g;
      uint32_t b;
      uint32_t a;
   } chan;
};

union util_format_r32_uscaled {
   struct {
      uint32_t r;
   } chan;
};

union util_format_r32g32_uscaled {
   struct {
      uint32_t r;
      uint32_t g;
   } chan;
};

union util_format_r32g32b32_uscaled {
   struct {
      uint32_t r;
      uint32_t g;
      uint32_t b;
   } chan;
};

union util_format_r32g32b32a32_uscaled {
   struct {
      uint32_t r;
      uint32_t g;
      uint32_t b;
      uint32_t a;
   } chan;
};

union util_format_r32_snorm {
   struct {
      int32_t r;
   } chan;
};

union util_format_r32g32_snorm {
   struct {
      int32_t r;
      int32_t g;
   } chan;
};

union util_format_r32g32b32_snorm {
   struct {
      int32_t r;
      int32_t g;
      int32_t b;
   } chan;
};

union util_format_r32g32b32a32_snorm {
   struct {
      int32_t r;
      int32_t g;
      int32_t b;
      int32_t a;
   } chan;
};

union util_format_r32_sscaled {
   struct {
      int32_t r;
   } chan;
};

union util_format_r32g32_sscaled {
   struct {
      int32_t r;
      int32_t g;
   } chan;
};

union util_format_r32g32b32_sscaled {
   struct {
      int32_t r;
      int32_t g;
      int32_t b;
   } chan;
};

union util_format_r32g32b32a32_sscaled {
   struct {
      int32_t r;
      int32_t g;
      int32_t b;
      int32_t a;
   } chan;
};

union util_format_r32_fixed {
   struct {
      int32_t r;
   } chan;
};

union util_format_r32g32_fixed {
   struct {
      int32_t r;
      int32_t g;
   } chan;
};

union util_format_r32g32b32_fixed {
   struct {
      int32_t r;
      int32_t g;
      int32_t b;
   } chan;
};

union util_format_r32g32b32a32_fixed {
   struct {
      int32_t r;
      int32_t g;
      int32_t b;
      int32_t a;
   } chan;
};

union util_format_r16_unorm {
   uint16_t value;
   struct {
      uint16_t r;
   } chan;
};

union util_format_r16g16_unorm {
   uint32_t value;
   struct {
      uint16_t r;
      uint16_t g;
   } chan;
};

union util_format_r16g16b16_unorm {
   struct {
      uint16_t r;
      uint16_t g;
      uint16_t b;
   } chan;
};

union util_format_r16g16b16a16_unorm {
   struct {
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t a;
   } chan;
};

union util_format_r16_uscaled {
   uint16_t value;
   struct {
      uint16_t r;
   } chan;
};

union util_format_r16g16_uscaled {
   uint32_t value;
   struct {
      uint16_t r;
      uint16_t g;
   } chan;
};

union util_format_r16g16b16_uscaled {
   struct {
      uint16_t r;
      uint16_t g;
      uint16_t b;
   } chan;
};

union util_format_r16g16b16a16_uscaled {
   struct {
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t a;
   } chan;
};

union util_format_r16_snorm {
   uint16_t value;
   struct {
      int16_t r;
   } chan;
};

union util_format_r16g16_snorm {
   uint32_t value;
   struct {
      int16_t r;
      int16_t g;
   } chan;
};

union util_format_r16g16b16_snorm {
   struct {
      int16_t r;
      int16_t g;
      int16_t b;
   } chan;
};

union util_format_r16g16b16a16_snorm {
   struct {
      int16_t r;
      int16_t g;
      int16_t b;
      int16_t a;
   } chan;
};

union util_format_r16_sscaled {
   uint16_t value;
   struct {
      int16_t r;
   } chan;
};

union util_format_r16g16_sscaled {
   uint32_t value;
   struct {
      int16_t r;
      int16_t g;
   } chan;
};

union util_format_r16g16b16_sscaled {
   struct {
      int16_t r;
      int16_t g;
      int16_t b;
   } chan;
};

union util_format_r16g16b16a16_sscaled {
   struct {
      int16_t r;
      int16_t g;
      int16_t b;
      int16_t a;
   } chan;
};

union util_format_r8_unorm {
   uint8_t value;
   struct {
      uint8_t r;
   } chan;
};

union util_format_r8g8_unorm {
   uint16_t value;
   struct {
      uint8_t r;
      uint8_t g;
   } chan;
};

union util_format_r8g8b8_unorm {
   struct {
      uint8_t r;
      uint8_t g;
      uint8_t b;
   } chan;
};

union util_format_r8g8b8a8_unorm {
   uint32_t value;
   struct {
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t a;
   } chan;
};

union util_format_r8_uscaled {
   uint8_t value;
   struct {
      uint8_t r;
   } chan;
};

union util_format_r8g8_uscaled {
   uint16_t value;
   struct {
      uint8_t r;
      uint8_t g;
   } chan;
};

union util_format_r8g8b8_uscaled {
   struct {
      uint8_t r;
      uint8_t g;
      uint8_t b;
   } chan;
};

union util_format_r8g8b8a8_uscaled {
   uint32_t value;
   struct {
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t a;
   } chan;
};

union util_format_r8_snorm {
   uint8_t value;
   struct {
      int8_t r;
   } chan;
};

union util_format_r8g8_snorm {
   uint16_t value;
   struct {
      int8_t r;
      int8_t g;
   } chan;
};

union util_format_r8g8b8_snorm {
   struct {
      int8_t r;
      int8_t g;
      int8_t b;
   } chan;
};

union util_format_r8g8b8a8_snorm {
   uint32_t value;
   struct {
      int8_t r;
      int8_t g;
      int8_t b;
      int8_t a;
   } chan;
};

union util_format_r8_sscaled {
   uint8_t value;
   struct {
      int8_t r;
   } chan;
};

union util_format_r8g8_sscaled {
   uint16_t value;
   struct {
      int8_t r;
      int8_t g;
   } chan;
};

union util_format_r8g8b8_sscaled {
   struct {
      int8_t r;
      int8_t g;
      int8_t b;
   } chan;
};

union util_format_r8g8b8a8_sscaled {
   uint32_t value;
   struct {
      int8_t r;
      int8_t g;
      int8_t b;
      int8_t a;
   } chan;
};

static INLINE void
util_format_b8g8r8a8_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_b8g8r8a8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xff)); /* b */
   dst[3] = (float)(pixel.chan.a * (1.0f/0xff)); /* a */
}

static INLINE void
util_format_b8g8r8x8_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_b8g8r8x8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xff)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_a8r8g8b8_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_a8r8g8b8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xff)); /* b */
   dst[3] = (float)(pixel.chan.a * (1.0f/0xff)); /* a */
}

static INLINE void
util_format_x8r8g8b8_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_x8r8g8b8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xff)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_a8b8g8r8_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_a8b8g8r8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xff)); /* b */
   dst[3] = (float)(pixel.chan.a * (1.0f/0xff)); /* a */
}

static INLINE void
util_format_x8b8g8r8_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_x8b8g8r8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xff)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_b5g5r5a1_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_b5g5r5a1_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap16(pixel.value);
#endif
   dst[0] = (float)(pixel.chan.r * (1.0f/0x1f)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0x1f)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0x1f)); /* b */
   dst[3] = (float)(pixel.chan.a * (1.0f/0x1)); /* a */
}

static INLINE void
util_format_b4g4r4a4_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_b4g4r4a4_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap16(pixel.value);
#endif
   dst[0] = (float)(pixel.chan.r * (1.0f/0xf)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xf)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xf)); /* b */
   dst[3] = (float)(pixel.chan.a * (1.0f/0xf)); /* a */
}

static INLINE void
util_format_b5g6r5_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_b5g6r5_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap16(pixel.value);
#endif
   dst[0] = (float)(pixel.chan.r * (1.0f/0x1f)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0x3f)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0x1f)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r10g10b10a2_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r10g10b10a2_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   dst[0] = (float)(pixel.chan.r * (1.0f/0x3ff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0x3ff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0x3ff)); /* b */
   dst[3] = (float)(pixel.chan.a * (1.0f/0x3)); /* a */
}

static INLINE void
util_format_l8_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_l8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.rgb * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.rgb * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.rgb * (1.0f/0xff)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_a8_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_a8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = 0; /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = (float)(pixel.chan.a * (1.0f/0xff)); /* a */
}

static INLINE void
util_format_i8_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_i8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.rgba * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.rgba * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.rgba * (1.0f/0xff)); /* b */
   dst[3] = (float)(pixel.chan.rgba * (1.0f/0xff)); /* a */
}

static INLINE void
util_format_l8a8_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_l8a8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.rgb * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.rgb * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.rgb * (1.0f/0xff)); /* b */
   dst[3] = (float)(pixel.chan.a * (1.0f/0xff)); /* a */
}

static INLINE void
util_format_l16_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_l16_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.rgb * (1.0f/0xffff)); /* r */
   dst[1] = (float)(pixel.chan.rgb * (1.0f/0xffff)); /* g */
   dst[2] = (float)(pixel.chan.rgb * (1.0f/0xffff)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_l8_srgb_unpack_4f(float *dst, const void *src)
{
   union util_format_l8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.rgb * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.rgb * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.rgb * (1.0f/0xff)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_l8a8_srgb_unpack_4f(float *dst, const void *src)
{
   union util_format_l8a8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.rgb * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.rgb * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.rgb * (1.0f/0xff)); /* b */
   dst[3] = (float)(pixel.chan.a * (1.0f/0xff)); /* a */
}

static INLINE void
util_format_r8g8b8_srgb_unpack_4f(float *dst, const void *src)
{
   union util_format_r8g8b8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xff)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_a8b8g8r8_srgb_unpack_4f(float *dst, const void *src)
{
   union util_format_a8b8g8r8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xff)); /* b */
   dst[3] = (float)(pixel.chan.a * (1.0f/0xff)); /* a */
}

static INLINE void
util_format_x8b8g8r8_srgb_unpack_4f(float *dst, const void *src)
{
   union util_format_x8b8g8r8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xff)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_b8g8r8a8_srgb_unpack_4f(float *dst, const void *src)
{
   union util_format_b8g8r8a8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xff)); /* b */
   dst[3] = (float)(pixel.chan.a * (1.0f/0xff)); /* a */
}

static INLINE void
util_format_b8g8r8x8_srgb_unpack_4f(float *dst, const void *src)
{
   union util_format_b8g8r8x8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xff)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_a8r8g8b8_srgb_unpack_4f(float *dst, const void *src)
{
   union util_format_a8r8g8b8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xff)); /* b */
   dst[3] = (float)(pixel.chan.a * (1.0f/0xff)); /* a */
}

static INLINE void
util_format_x8r8g8b8_srgb_unpack_4f(float *dst, const void *src)
{
   union util_format_x8r8g8b8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xff)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r8sg8sb8ux8u_norm_unpack_4f(float *dst, const void *src)
{
   union util_format_r8sg8sb8ux8u_norm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0x7f)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0x7f)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xff)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r5sg5sb6u_norm_unpack_4f(float *dst, const void *src)
{
   union util_format_r5sg5sb6u_norm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap16(pixel.value);
#endif
   dst[0] = (float)(pixel.chan.r * (1.0f/0xf)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xf)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0x3f)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_z16_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_z16_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.z * (1.0f/0xffff)); /* r */
   dst[1] = dst[0]; /* g */
   dst[2] = dst[0]; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_z32_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_z32_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.z * (1.0/0xffffffff)); /* r */
   dst[1] = dst[0]; /* g */
   dst[2] = dst[0]; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_z32_float_unpack_4f(float *dst, const void *src)
{
   union util_format_z32_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.z; /* r */
   dst[1] = dst[0]; /* g */
   dst[2] = dst[0]; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_z24s8_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_z24s8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   dst[0] = (float)(pixel.chan.z * (1.0/0xffffff)); /* r */
   dst[1] = dst[0]; /* g */
   dst[2] = dst[0]; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_s8z24_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_s8z24_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   dst[0] = (float)(pixel.chan.z * (1.0/0xffffff)); /* r */
   dst[1] = dst[0]; /* g */
   dst[2] = dst[0]; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_z24x8_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_z24x8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   dst[0] = (float)(pixel.chan.z * (1.0/0xffffff)); /* r */
   dst[1] = dst[0]; /* g */
   dst[2] = dst[0]; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_x8z24_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_x8z24_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   dst[0] = (float)(pixel.chan.z * (1.0/0xffffff)); /* r */
   dst[1] = dst[0]; /* g */
   dst[2] = dst[0]; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r64_float_unpack_4f(float *dst, const void *src)
{
   union util_format_r64_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r64g64_float_unpack_4f(float *dst, const void *src)
{
   union util_format_r64g64_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r64g64b64_float_unpack_4f(float *dst, const void *src)
{
   union util_format_r64g64b64_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = (float)pixel.chan.b; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r64g64b64a64_float_unpack_4f(float *dst, const void *src)
{
   union util_format_r64g64b64a64_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = (float)pixel.chan.b; /* b */
   dst[3] = (float)pixel.chan.a; /* a */
}

static INLINE void
util_format_r32_float_unpack_4f(float *dst, const void *src)
{
   union util_format_r32_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32_float_unpack_4f(float *dst, const void *src)
{
   union util_format_r32g32_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32b32_float_unpack_4f(float *dst, const void *src)
{
   union util_format_r32g32b32_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32b32a32_float_unpack_4f(float *dst, const void *src)
{
   union util_format_r32g32b32a32_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = pixel.chan.a; /* a */
}

static INLINE void
util_format_r32_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r32_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r32g32_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32b32_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r32g32b32_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0/0xffffffff)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32b32a32_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r32g32b32a32_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0/0xffffffff)); /* b */
   dst[3] = (float)(pixel.chan.a * (1.0/0xffffffff)); /* a */
}

static INLINE void
util_format_r32_uscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r32_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32_uscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r32g32_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32b32_uscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r32g32b32_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = (float)pixel.chan.b; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32b32a32_uscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r32g32b32a32_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = (float)pixel.chan.b; /* b */
   dst[3] = (float)pixel.chan.a; /* a */
}

static INLINE void
util_format_r32_snorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r32_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32_snorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r32g32_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32b32_snorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r32g32b32_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0/0x7fffffff)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32b32a32_snorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r32g32b32a32_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0/0x7fffffff)); /* b */
   dst[3] = (float)(pixel.chan.a * (1.0/0x7fffffff)); /* a */
}

static INLINE void
util_format_r32_sscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r32_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32_sscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r32g32_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32b32_sscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r32g32b32_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = (float)pixel.chan.b; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32b32a32_sscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r32g32b32a32_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = (float)pixel.chan.b; /* b */
   dst[3] = (float)pixel.chan.a; /* a */
}

static INLINE void
util_format_r16_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r16_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r16g16_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16b16_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r16g16b16_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16b16a16_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r16g16b16a16_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
   dst[3] = (float)(pixel.chan.a * (1.0f/0xffff)); /* a */
}

static INLINE void
util_format_r16_uscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r16_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16_uscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r16g16_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16b16_uscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r16g16b16_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = (float)pixel.chan.b; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16b16a16_uscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r16g16b16a16_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = (float)pixel.chan.b; /* b */
   dst[3] = (float)pixel.chan.a; /* a */
}

static INLINE void
util_format_r16_snorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r16_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16_snorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r16g16_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16b16_snorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r16g16b16_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16b16a16_snorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r16g16b16a16_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
   dst[3] = (float)(pixel.chan.a * (1.0f/0x7fff)); /* a */
}

static INLINE void
util_format_r16_sscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r16_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16_sscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r16g16_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16b16_sscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r16g16b16_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = (float)pixel.chan.b; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16b16a16_sscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r16g16b16a16_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = (float)pixel.chan.b; /* b */
   dst[3] = (float)pixel.chan.a; /* a */
}

static INLINE void
util_format_r8_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xff)); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r8g8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xff)); /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8b8_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r8g8b8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xff)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8b8a8_unorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r8g8b8a8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0xff)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0xff)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0xff)); /* b */
   dst[3] = (float)(pixel.chan.a * (1.0f/0xff)); /* a */
}

static INLINE void
util_format_r8_uscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r8_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8_uscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r8g8_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8b8_uscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r8g8b8_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = (float)pixel.chan.b; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8b8a8_uscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r8g8b8a8_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = (float)pixel.chan.b; /* b */
   dst[3] = (float)pixel.chan.a; /* a */
}

static INLINE void
util_format_r8_snorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r8_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0x7f)); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8_snorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r8g8_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0x7f)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0x7f)); /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8b8_snorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r8g8b8_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0x7f)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0x7f)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0x7f)); /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8b8a8_snorm_unpack_4f(float *dst, const void *src)
{
   union util_format_r8g8b8a8_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)(pixel.chan.r * (1.0f/0x7f)); /* r */
   dst[1] = (float)(pixel.chan.g * (1.0f/0x7f)); /* g */
   dst[2] = (float)(pixel.chan.b * (1.0f/0x7f)); /* b */
   dst[3] = (float)(pixel.chan.a * (1.0f/0x7f)); /* a */
}

static INLINE void
util_format_r8_sscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r8_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8_sscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r8g8_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = 0; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8b8_sscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r8g8b8_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = (float)pixel.chan.b; /* b */
   dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8b8a8_sscaled_unpack_4f(float *dst, const void *src)
{
   union util_format_r8g8b8a8_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (float)pixel.chan.r; /* r */
   dst[1] = (float)pixel.chan.g; /* g */
   dst[2] = (float)pixel.chan.b; /* b */
   dst[3] = (float)pixel.chan.a; /* a */
}

static INLINE void
util_format_unpack_4f(enum pipe_format format, float *dst, const void *src)
{
   void (*func)(float *dst, const void *src);
   switch(format) {
   case PIPE_FORMAT_B8G8R8A8_UNORM:
      func = &util_format_b8g8r8a8_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_B8G8R8X8_UNORM:
      func = &util_format_b8g8r8x8_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_A8R8G8B8_UNORM:
      func = &util_format_a8r8g8b8_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_X8R8G8B8_UNORM:
      func = &util_format_x8r8g8b8_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_A8B8G8R8_UNORM:
      func = &util_format_a8b8g8r8_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_X8B8G8R8_UNORM:
      func = &util_format_x8b8g8r8_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_B5G5R5A1_UNORM:
      func = &util_format_b5g5r5a1_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_B4G4R4A4_UNORM:
      func = &util_format_b4g4r4a4_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_B5G6R5_UNORM:
      func = &util_format_b5g6r5_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_R10G10B10A2_UNORM:
      func = &util_format_r10g10b10a2_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_L8_UNORM:
      func = &util_format_l8_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_A8_UNORM:
      func = &util_format_a8_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_I8_UNORM:
      func = &util_format_i8_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_L8A8_UNORM:
      func = &util_format_l8a8_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_L16_UNORM:
      func = &util_format_l16_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_L8_SRGB:
      func = &util_format_l8_srgb_unpack_4f;
      break;
   case PIPE_FORMAT_L8A8_SRGB:
      func = &util_format_l8a8_srgb_unpack_4f;
      break;
   case PIPE_FORMAT_R8G8B8_SRGB:
      func = &util_format_r8g8b8_srgb_unpack_4f;
      break;
   case PIPE_FORMAT_A8B8G8R8_SRGB:
      func = &util_format_a8b8g8r8_srgb_unpack_4f;
      break;
   case PIPE_FORMAT_X8B8G8R8_SRGB:
      func = &util_format_x8b8g8r8_srgb_unpack_4f;
      break;
   case PIPE_FORMAT_B8G8R8A8_SRGB:
      func = &util_format_b8g8r8a8_srgb_unpack_4f;
      break;
   case PIPE_FORMAT_B8G8R8X8_SRGB:
      func = &util_format_b8g8r8x8_srgb_unpack_4f;
      break;
   case PIPE_FORMAT_A8R8G8B8_SRGB:
      func = &util_format_a8r8g8b8_srgb_unpack_4f;
      break;
   case PIPE_FORMAT_X8R8G8B8_SRGB:
      func = &util_format_x8r8g8b8_srgb_unpack_4f;
      break;
   case PIPE_FORMAT_R8SG8SB8UX8U_NORM:
      func = &util_format_r8sg8sb8ux8u_norm_unpack_4f;
      break;
   case PIPE_FORMAT_R5SG5SB6U_NORM:
      func = &util_format_r5sg5sb6u_norm_unpack_4f;
      break;
   case PIPE_FORMAT_Z16_UNORM:
      func = &util_format_z16_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_Z32_UNORM:
      func = &util_format_z32_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_Z32_FLOAT:
      func = &util_format_z32_float_unpack_4f;
      break;
   case PIPE_FORMAT_Z24S8_UNORM:
      func = &util_format_z24s8_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_S8Z24_UNORM:
      func = &util_format_s8z24_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_Z24X8_UNORM:
      func = &util_format_z24x8_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_X8Z24_UNORM:
      func = &util_format_x8z24_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_R64_FLOAT:
      func = &util_format_r64_float_unpack_4f;
      break;
   case PIPE_FORMAT_R64G64_FLOAT:
      func = &util_format_r64g64_float_unpack_4f;
      break;
   case PIPE_FORMAT_R64G64B64_FLOAT:
      func = &util_format_r64g64b64_float_unpack_4f;
      break;
   case PIPE_FORMAT_R64G64B64A64_FLOAT:
      func = &util_format_r64g64b64a64_float_unpack_4f;
      break;
   case PIPE_FORMAT_R32_FLOAT:
      func = &util_format_r32_float_unpack_4f;
      break;
   case PIPE_FORMAT_R32G32_FLOAT:
      func = &util_format_r32g32_float_unpack_4f;
      break;
   case PIPE_FORMAT_R32G32B32_FLOAT:
      func = &util_format_r32g32b32_float_unpack_4f;
      break;
   case PIPE_FORMAT_R32G32B32A32_FLOAT:
      func = &util_format_r32g32b32a32_float_unpack_4f;
      break;
   case PIPE_FORMAT_R32_UNORM:
      func = &util_format_r32_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_R32G32_UNORM:
      func = &util_format_r32g32_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_R32G32B32_UNORM:
      func = &util_format_r32g32b32_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_R32G32B32A32_UNORM:
      func = &util_format_r32g32b32a32_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_R32_USCALED:
      func = &util_format_r32_uscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R32G32_USCALED:
      func = &util_format_r32g32_uscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R32G32B32_USCALED:
      func = &util_format_r32g32b32_uscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R32G32B32A32_USCALED:
      func = &util_format_r32g32b32a32_uscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R32_SNORM:
      func = &util_format_r32_snorm_unpack_4f;
      break;
   case PIPE_FORMAT_R32G32_SNORM:
      func = &util_format_r32g32_snorm_unpack_4f;
      break;
   case PIPE_FORMAT_R32G32B32_SNORM:
      func = &util_format_r32g32b32_snorm_unpack_4f;
      break;
   case PIPE_FORMAT_R32G32B32A32_SNORM:
      func = &util_format_r32g32b32a32_snorm_unpack_4f;
      break;
   case PIPE_FORMAT_R32_SSCALED:
      func = &util_format_r32_sscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R32G32_SSCALED:
      func = &util_format_r32g32_sscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R32G32B32_SSCALED:
      func = &util_format_r32g32b32_sscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R32G32B32A32_SSCALED:
      func = &util_format_r32g32b32a32_sscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R16_UNORM:
      func = &util_format_r16_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_R16G16_UNORM:
      func = &util_format_r16g16_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_R16G16B16_UNORM:
      func = &util_format_r16g16b16_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_R16G16B16A16_UNORM:
      func = &util_format_r16g16b16a16_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_R16_USCALED:
      func = &util_format_r16_uscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R16G16_USCALED:
      func = &util_format_r16g16_uscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R16G16B16_USCALED:
      func = &util_format_r16g16b16_uscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R16G16B16A16_USCALED:
      func = &util_format_r16g16b16a16_uscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R16_SNORM:
      func = &util_format_r16_snorm_unpack_4f;
      break;
   case PIPE_FORMAT_R16G16_SNORM:
      func = &util_format_r16g16_snorm_unpack_4f;
      break;
   case PIPE_FORMAT_R16G16B16_SNORM:
      func = &util_format_r16g16b16_snorm_unpack_4f;
      break;
   case PIPE_FORMAT_R16G16B16A16_SNORM:
      func = &util_format_r16g16b16a16_snorm_unpack_4f;
      break;
   case PIPE_FORMAT_R16_SSCALED:
      func = &util_format_r16_sscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R16G16_SSCALED:
      func = &util_format_r16g16_sscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R16G16B16_SSCALED:
      func = &util_format_r16g16b16_sscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R16G16B16A16_SSCALED:
      func = &util_format_r16g16b16a16_sscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R8_UNORM:
      func = &util_format_r8_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_R8G8_UNORM:
      func = &util_format_r8g8_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_R8G8B8_UNORM:
      func = &util_format_r8g8b8_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_R8G8B8A8_UNORM:
      func = &util_format_r8g8b8a8_unorm_unpack_4f;
      break;
   case PIPE_FORMAT_R8_USCALED:
      func = &util_format_r8_uscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R8G8_USCALED:
      func = &util_format_r8g8_uscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R8G8B8_USCALED:
      func = &util_format_r8g8b8_uscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R8G8B8A8_USCALED:
      func = &util_format_r8g8b8a8_uscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R8_SNORM:
      func = &util_format_r8_snorm_unpack_4f;
      break;
   case PIPE_FORMAT_R8G8_SNORM:
      func = &util_format_r8g8_snorm_unpack_4f;
      break;
   case PIPE_FORMAT_R8G8B8_SNORM:
      func = &util_format_r8g8b8_snorm_unpack_4f;
      break;
   case PIPE_FORMAT_R8G8B8A8_SNORM:
      func = &util_format_r8g8b8a8_snorm_unpack_4f;
      break;
   case PIPE_FORMAT_R8_SSCALED:
      func = &util_format_r8_sscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R8G8_SSCALED:
      func = &util_format_r8g8_sscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R8G8B8_SSCALED:
      func = &util_format_r8g8b8_sscaled_unpack_4f;
      break;
   case PIPE_FORMAT_R8G8B8A8_SSCALED:
      func = &util_format_r8g8b8a8_sscaled_unpack_4f;
      break;
   default:
      debug_printf("unsupported format\n");
      return;
   }
   func(dst, src);
}

static INLINE void
util_format_b8g8r8a8_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_b8g8r8a8_unorm pixel;
   pixel.chan.b = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   pixel.chan.g = (uint8_t)(CLAMP(g, 0, 1) * 0xff);
   pixel.chan.r = (uint8_t)(CLAMP(r, 0, 1) * 0xff);
   pixel.chan.a = (uint8_t)(CLAMP(a, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_b8g8r8x8_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_b8g8r8x8_unorm pixel;
   pixel.chan.b = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   pixel.chan.g = (uint8_t)(CLAMP(g, 0, 1) * 0xff);
   pixel.chan.r = (uint8_t)(CLAMP(r, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_a8r8g8b8_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_a8r8g8b8_unorm pixel;
   pixel.chan.a = (uint8_t)(CLAMP(a, 0, 1) * 0xff);
   pixel.chan.r = (uint8_t)(CLAMP(r, 0, 1) * 0xff);
   pixel.chan.g = (uint8_t)(CLAMP(g, 0, 1) * 0xff);
   pixel.chan.b = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_x8r8g8b8_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_x8r8g8b8_unorm pixel;
   pixel.chan.r = (uint8_t)(CLAMP(r, 0, 1) * 0xff);
   pixel.chan.g = (uint8_t)(CLAMP(g, 0, 1) * 0xff);
   pixel.chan.b = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_a8b8g8r8_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_a8b8g8r8_unorm pixel;
   pixel.chan.a = (uint8_t)(CLAMP(a, 0, 1) * 0xff);
   pixel.chan.b = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   pixel.chan.g = (uint8_t)(CLAMP(g, 0, 1) * 0xff);
   pixel.chan.r = (uint8_t)(CLAMP(r, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_x8b8g8r8_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_x8b8g8r8_unorm pixel;
   pixel.chan.b = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   pixel.chan.g = (uint8_t)(CLAMP(g, 0, 1) * 0xff);
   pixel.chan.r = (uint8_t)(CLAMP(r, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_b5g5r5a1_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_b5g5r5a1_unorm pixel;
   pixel.chan.b = (uint16_t)(CLAMP(b, 0, 1) * 0x1f);
   pixel.chan.g = (uint16_t)(CLAMP(g, 0, 1) * 0x1f);
   pixel.chan.r = (uint16_t)(CLAMP(r, 0, 1) * 0x1f);
   pixel.chan.a = (uint16_t)(CLAMP(a, 0, 1) * 0x1);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap16(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_b4g4r4a4_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_b4g4r4a4_unorm pixel;
   pixel.chan.b = (uint16_t)(CLAMP(b, 0, 1) * 0xf);
   pixel.chan.g = (uint16_t)(CLAMP(g, 0, 1) * 0xf);
   pixel.chan.r = (uint16_t)(CLAMP(r, 0, 1) * 0xf);
   pixel.chan.a = (uint16_t)(CLAMP(a, 0, 1) * 0xf);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap16(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_b5g6r5_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_b5g6r5_unorm pixel;
   pixel.chan.b = (uint16_t)(CLAMP(b, 0, 1) * 0x1f);
   pixel.chan.g = (uint16_t)(CLAMP(g, 0, 1) * 0x3f);
   pixel.chan.r = (uint16_t)(CLAMP(r, 0, 1) * 0x1f);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap16(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r10g10b10a2_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r10g10b10a2_unorm pixel;
   pixel.chan.r = (uint32_t)(CLAMP(r, 0, 1) * 0x3ff);
   pixel.chan.g = (uint32_t)(CLAMP(g, 0, 1) * 0x3ff);
   pixel.chan.b = (uint32_t)(CLAMP(b, 0, 1) * 0x3ff);
   pixel.chan.a = (uint32_t)(CLAMP(a, 0, 1) * 0x3);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_l8_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_l8_unorm pixel;
   pixel.chan.rgb = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_a8_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_a8_unorm pixel;
   pixel.chan.a = (uint8_t)(CLAMP(a, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_i8_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_i8_unorm pixel;
   pixel.chan.rgba = (uint8_t)(CLAMP(a, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_l8a8_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_l8a8_unorm pixel;
   pixel.chan.rgb = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   pixel.chan.a = (uint8_t)(CLAMP(a, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_l16_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_l16_unorm pixel;
   pixel.chan.rgb = (uint16_t)(CLAMP(b, 0, 1) * 0xffff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_l8_srgb_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_l8_srgb pixel;
   pixel.chan.rgb = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_l8a8_srgb_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_l8a8_srgb pixel;
   pixel.chan.rgb = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   pixel.chan.a = (uint8_t)(CLAMP(a, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8_srgb_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8g8b8_srgb pixel;
   pixel.chan.r = (uint8_t)(CLAMP(r, 0, 1) * 0xff);
   pixel.chan.g = (uint8_t)(CLAMP(g, 0, 1) * 0xff);
   pixel.chan.b = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_a8b8g8r8_srgb_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_a8b8g8r8_srgb pixel;
   pixel.chan.a = (uint8_t)(CLAMP(a, 0, 1) * 0xff);
   pixel.chan.b = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   pixel.chan.g = (uint8_t)(CLAMP(g, 0, 1) * 0xff);
   pixel.chan.r = (uint8_t)(CLAMP(r, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_x8b8g8r8_srgb_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_x8b8g8r8_srgb pixel;
   pixel.chan.b = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   pixel.chan.g = (uint8_t)(CLAMP(g, 0, 1) * 0xff);
   pixel.chan.r = (uint8_t)(CLAMP(r, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_b8g8r8a8_srgb_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_b8g8r8a8_srgb pixel;
   pixel.chan.b = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   pixel.chan.g = (uint8_t)(CLAMP(g, 0, 1) * 0xff);
   pixel.chan.r = (uint8_t)(CLAMP(r, 0, 1) * 0xff);
   pixel.chan.a = (uint8_t)(CLAMP(a, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_b8g8r8x8_srgb_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_b8g8r8x8_srgb pixel;
   pixel.chan.b = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   pixel.chan.g = (uint8_t)(CLAMP(g, 0, 1) * 0xff);
   pixel.chan.r = (uint8_t)(CLAMP(r, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_a8r8g8b8_srgb_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_a8r8g8b8_srgb pixel;
   pixel.chan.a = (uint8_t)(CLAMP(a, 0, 1) * 0xff);
   pixel.chan.r = (uint8_t)(CLAMP(r, 0, 1) * 0xff);
   pixel.chan.g = (uint8_t)(CLAMP(g, 0, 1) * 0xff);
   pixel.chan.b = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_x8r8g8b8_srgb_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_x8r8g8b8_srgb pixel;
   pixel.chan.r = (uint8_t)(CLAMP(r, 0, 1) * 0xff);
   pixel.chan.g = (uint8_t)(CLAMP(g, 0, 1) * 0xff);
   pixel.chan.b = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8sg8sb8ux8u_norm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8sg8sb8ux8u_norm pixel;
   pixel.chan.r = (int8_t)(CLAMP(r, -1, 1) * 0x7f);
   pixel.chan.g = (int8_t)(CLAMP(g, -1, 1) * 0x7f);
   pixel.chan.b = (int8_t)(CLAMP(b, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r5sg5sb6u_norm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r5sg5sb6u_norm pixel;
   pixel.chan.r = (uint16_t)(CLAMP(r, -1, 1) * 0xf);
   pixel.chan.g = (uint16_t)(CLAMP(g, -1, 1) * 0xf);
   pixel.chan.b = (uint16_t)(CLAMP(b, 0, 1) * 0x3f);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap16(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_z16_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_z16_unorm pixel;
   pixel.chan.z = (uint16_t)(CLAMP(r, 0, 1) * 0xffff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_z32_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_z32_unorm pixel;
   pixel.chan.z = (uint32_t)(CLAMP(r, 0, 1) * (double)0xffffffff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_z32_float_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_z32_float pixel;
   pixel.chan.z = r;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_z24s8_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_z24s8_unorm pixel;
   pixel.chan.z = (uint32_t)(CLAMP(r, 0, 1) * (double)0xffffff);
   pixel.chan.s = 0;
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_s8z24_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_s8z24_unorm pixel;
   pixel.chan.s = (uint32_t)(CLAMP(g, 0, 1) * 0xff);
   pixel.chan.z = 0;
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_z24x8_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_z24x8_unorm pixel;
   pixel.chan.z = (uint32_t)(CLAMP(r, 0, 1) * (double)0xffffff);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_x8z24_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_x8z24_unorm pixel;
   pixel.chan.z = 0;
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r64_float_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r64_float pixel;
   pixel.chan.r = (double)r;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r64g64_float_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r64g64_float pixel;
   pixel.chan.r = (double)r;
   pixel.chan.g = (double)g;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r64g64b64_float_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r64g64b64_float pixel;
   pixel.chan.r = (double)r;
   pixel.chan.g = (double)g;
   pixel.chan.b = (double)b;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r64g64b64a64_float_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r64g64b64a64_float pixel;
   pixel.chan.r = (double)r;
   pixel.chan.g = (double)g;
   pixel.chan.b = (double)b;
   pixel.chan.a = (double)a;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32_float_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32_float pixel;
   pixel.chan.r = r;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32_float_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32g32_float pixel;
   pixel.chan.r = r;
   pixel.chan.g = g;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32_float_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32g32b32_float pixel;
   pixel.chan.r = r;
   pixel.chan.g = g;
   pixel.chan.b = b;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32a32_float_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32g32b32a32_float pixel;
   pixel.chan.r = r;
   pixel.chan.g = g;
   pixel.chan.b = b;
   pixel.chan.a = a;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32_unorm pixel;
   pixel.chan.r = (uint32_t)(CLAMP(r, 0, 1) * (double)0xffffffff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32g32_unorm pixel;
   pixel.chan.r = (uint32_t)(CLAMP(r, 0, 1) * (double)0xffffffff);
   pixel.chan.g = (uint32_t)(CLAMP(g, 0, 1) * (double)0xffffffff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32g32b32_unorm pixel;
   pixel.chan.r = (uint32_t)(CLAMP(r, 0, 1) * (double)0xffffffff);
   pixel.chan.g = (uint32_t)(CLAMP(g, 0, 1) * (double)0xffffffff);
   pixel.chan.b = (uint32_t)(CLAMP(b, 0, 1) * (double)0xffffffff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32a32_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32g32b32a32_unorm pixel;
   pixel.chan.r = (uint32_t)(CLAMP(r, 0, 1) * (double)0xffffffff);
   pixel.chan.g = (uint32_t)(CLAMP(g, 0, 1) * (double)0xffffffff);
   pixel.chan.b = (uint32_t)(CLAMP(b, 0, 1) * (double)0xffffffff);
   pixel.chan.a = (uint32_t)(CLAMP(a, 0, 1) * (double)0xffffffff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32_uscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32_uscaled pixel;
   pixel.chan.r = (uint32_t)r;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32_uscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32g32_uscaled pixel;
   pixel.chan.r = (uint32_t)r;
   pixel.chan.g = (uint32_t)g;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32_uscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32g32b32_uscaled pixel;
   pixel.chan.r = (uint32_t)r;
   pixel.chan.g = (uint32_t)g;
   pixel.chan.b = (uint32_t)b;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32a32_uscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32g32b32a32_uscaled pixel;
   pixel.chan.r = (uint32_t)r;
   pixel.chan.g = (uint32_t)g;
   pixel.chan.b = (uint32_t)b;
   pixel.chan.a = (uint32_t)a;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32_snorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32_snorm pixel;
   pixel.chan.r = (int32_t)(CLAMP(r, -1, 1) * (double)0x7fffffff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32_snorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32g32_snorm pixel;
   pixel.chan.r = (int32_t)(CLAMP(r, -1, 1) * (double)0x7fffffff);
   pixel.chan.g = (int32_t)(CLAMP(g, -1, 1) * (double)0x7fffffff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32_snorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32g32b32_snorm pixel;
   pixel.chan.r = (int32_t)(CLAMP(r, -1, 1) * (double)0x7fffffff);
   pixel.chan.g = (int32_t)(CLAMP(g, -1, 1) * (double)0x7fffffff);
   pixel.chan.b = (int32_t)(CLAMP(b, -1, 1) * (double)0x7fffffff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32a32_snorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32g32b32a32_snorm pixel;
   pixel.chan.r = (int32_t)(CLAMP(r, -1, 1) * (double)0x7fffffff);
   pixel.chan.g = (int32_t)(CLAMP(g, -1, 1) * (double)0x7fffffff);
   pixel.chan.b = (int32_t)(CLAMP(b, -1, 1) * (double)0x7fffffff);
   pixel.chan.a = (int32_t)(CLAMP(a, -1, 1) * (double)0x7fffffff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32_sscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32_sscaled pixel;
   pixel.chan.r = (int32_t)r;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32_sscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32g32_sscaled pixel;
   pixel.chan.r = (int32_t)r;
   pixel.chan.g = (int32_t)g;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32_sscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32g32b32_sscaled pixel;
   pixel.chan.r = (int32_t)r;
   pixel.chan.g = (int32_t)g;
   pixel.chan.b = (int32_t)b;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32a32_sscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r32g32b32a32_sscaled pixel;
   pixel.chan.r = (int32_t)r;
   pixel.chan.g = (int32_t)g;
   pixel.chan.b = (int32_t)b;
   pixel.chan.a = (int32_t)a;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r16_unorm pixel;
   pixel.chan.r = (uint16_t)(CLAMP(r, 0, 1) * 0xffff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r16g16_unorm pixel;
   pixel.chan.r = (uint16_t)(CLAMP(r, 0, 1) * 0xffff);
   pixel.chan.g = (uint16_t)(CLAMP(g, 0, 1) * 0xffff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16b16_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r16g16b16_unorm pixel;
   pixel.chan.r = (uint16_t)(CLAMP(r, 0, 1) * 0xffff);
   pixel.chan.g = (uint16_t)(CLAMP(g, 0, 1) * 0xffff);
   pixel.chan.b = (uint16_t)(CLAMP(b, 0, 1) * 0xffff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16b16a16_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r16g16b16a16_unorm pixel;
   pixel.chan.r = (uint16_t)(CLAMP(r, 0, 1) * 0xffff);
   pixel.chan.g = (uint16_t)(CLAMP(g, 0, 1) * 0xffff);
   pixel.chan.b = (uint16_t)(CLAMP(b, 0, 1) * 0xffff);
   pixel.chan.a = (uint16_t)(CLAMP(a, 0, 1) * 0xffff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16_uscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r16_uscaled pixel;
   pixel.chan.r = (uint16_t)r;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16_uscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r16g16_uscaled pixel;
   pixel.chan.r = (uint16_t)r;
   pixel.chan.g = (uint16_t)g;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16b16_uscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r16g16b16_uscaled pixel;
   pixel.chan.r = (uint16_t)r;
   pixel.chan.g = (uint16_t)g;
   pixel.chan.b = (uint16_t)b;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16b16a16_uscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r16g16b16a16_uscaled pixel;
   pixel.chan.r = (uint16_t)r;
   pixel.chan.g = (uint16_t)g;
   pixel.chan.b = (uint16_t)b;
   pixel.chan.a = (uint16_t)a;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16_snorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r16_snorm pixel;
   pixel.chan.r = (int16_t)(CLAMP(r, -1, 1) * 0x7fff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16_snorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r16g16_snorm pixel;
   pixel.chan.r = (int16_t)(CLAMP(r, -1, 1) * 0x7fff);
   pixel.chan.g = (int16_t)(CLAMP(g, -1, 1) * 0x7fff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16b16_snorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r16g16b16_snorm pixel;
   pixel.chan.r = (int16_t)(CLAMP(r, -1, 1) * 0x7fff);
   pixel.chan.g = (int16_t)(CLAMP(g, -1, 1) * 0x7fff);
   pixel.chan.b = (int16_t)(CLAMP(b, -1, 1) * 0x7fff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16b16a16_snorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r16g16b16a16_snorm pixel;
   pixel.chan.r = (int16_t)(CLAMP(r, -1, 1) * 0x7fff);
   pixel.chan.g = (int16_t)(CLAMP(g, -1, 1) * 0x7fff);
   pixel.chan.b = (int16_t)(CLAMP(b, -1, 1) * 0x7fff);
   pixel.chan.a = (int16_t)(CLAMP(a, -1, 1) * 0x7fff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16_sscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r16_sscaled pixel;
   pixel.chan.r = (int16_t)r;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16_sscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r16g16_sscaled pixel;
   pixel.chan.r = (int16_t)r;
   pixel.chan.g = (int16_t)g;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16b16_sscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r16g16b16_sscaled pixel;
   pixel.chan.r = (int16_t)r;
   pixel.chan.g = (int16_t)g;
   pixel.chan.b = (int16_t)b;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16b16a16_sscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r16g16b16a16_sscaled pixel;
   pixel.chan.r = (int16_t)r;
   pixel.chan.g = (int16_t)g;
   pixel.chan.b = (int16_t)b;
   pixel.chan.a = (int16_t)a;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8_unorm pixel;
   pixel.chan.r = (uint8_t)(CLAMP(r, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8g8_unorm pixel;
   pixel.chan.r = (uint8_t)(CLAMP(r, 0, 1) * 0xff);
   pixel.chan.g = (uint8_t)(CLAMP(g, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8g8b8_unorm pixel;
   pixel.chan.r = (uint8_t)(CLAMP(r, 0, 1) * 0xff);
   pixel.chan.g = (uint8_t)(CLAMP(g, 0, 1) * 0xff);
   pixel.chan.b = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8a8_unorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8g8b8a8_unorm pixel;
   pixel.chan.r = (uint8_t)(CLAMP(r, 0, 1) * 0xff);
   pixel.chan.g = (uint8_t)(CLAMP(g, 0, 1) * 0xff);
   pixel.chan.b = (uint8_t)(CLAMP(b, 0, 1) * 0xff);
   pixel.chan.a = (uint8_t)(CLAMP(a, 0, 1) * 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8_uscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8_uscaled pixel;
   pixel.chan.r = (uint8_t)r;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8_uscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8g8_uscaled pixel;
   pixel.chan.r = (uint8_t)r;
   pixel.chan.g = (uint8_t)g;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8_uscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8g8b8_uscaled pixel;
   pixel.chan.r = (uint8_t)r;
   pixel.chan.g = (uint8_t)g;
   pixel.chan.b = (uint8_t)b;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8a8_uscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8g8b8a8_uscaled pixel;
   pixel.chan.r = (uint8_t)r;
   pixel.chan.g = (uint8_t)g;
   pixel.chan.b = (uint8_t)b;
   pixel.chan.a = (uint8_t)a;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8_snorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8_snorm pixel;
   pixel.chan.r = (int8_t)(CLAMP(r, -1, 1) * 0x7f);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8_snorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8g8_snorm pixel;
   pixel.chan.r = (int8_t)(CLAMP(r, -1, 1) * 0x7f);
   pixel.chan.g = (int8_t)(CLAMP(g, -1, 1) * 0x7f);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8_snorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8g8b8_snorm pixel;
   pixel.chan.r = (int8_t)(CLAMP(r, -1, 1) * 0x7f);
   pixel.chan.g = (int8_t)(CLAMP(g, -1, 1) * 0x7f);
   pixel.chan.b = (int8_t)(CLAMP(b, -1, 1) * 0x7f);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8a8_snorm_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8g8b8a8_snorm pixel;
   pixel.chan.r = (int8_t)(CLAMP(r, -1, 1) * 0x7f);
   pixel.chan.g = (int8_t)(CLAMP(g, -1, 1) * 0x7f);
   pixel.chan.b = (int8_t)(CLAMP(b, -1, 1) * 0x7f);
   pixel.chan.a = (int8_t)(CLAMP(a, -1, 1) * 0x7f);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8_sscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8_sscaled pixel;
   pixel.chan.r = (int8_t)r;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8_sscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8g8_sscaled pixel;
   pixel.chan.r = (int8_t)r;
   pixel.chan.g = (int8_t)g;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8_sscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8g8b8_sscaled pixel;
   pixel.chan.r = (int8_t)r;
   pixel.chan.g = (int8_t)g;
   pixel.chan.b = (int8_t)b;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8a8_sscaled_pack_4f(void *dst, float r, float g, float b, float a)
{
   union util_format_r8g8b8a8_sscaled pixel;
   pixel.chan.r = (int8_t)r;
   pixel.chan.g = (int8_t)g;
   pixel.chan.b = (int8_t)b;
   pixel.chan.a = (int8_t)a;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_pack_4f(enum pipe_format format, void *dst, float r, float g, float b, float a)
{
   void (*func)(void *dst, float r, float g, float b, float a);
   switch(format) {
   case PIPE_FORMAT_B8G8R8A8_UNORM:
      func = &util_format_b8g8r8a8_unorm_pack_4f;
      break;
   case PIPE_FORMAT_B8G8R8X8_UNORM:
      func = &util_format_b8g8r8x8_unorm_pack_4f;
      break;
   case PIPE_FORMAT_A8R8G8B8_UNORM:
      func = &util_format_a8r8g8b8_unorm_pack_4f;
      break;
   case PIPE_FORMAT_X8R8G8B8_UNORM:
      func = &util_format_x8r8g8b8_unorm_pack_4f;
      break;
   case PIPE_FORMAT_A8B8G8R8_UNORM:
      func = &util_format_a8b8g8r8_unorm_pack_4f;
      break;
   case PIPE_FORMAT_X8B8G8R8_UNORM:
      func = &util_format_x8b8g8r8_unorm_pack_4f;
      break;
   case PIPE_FORMAT_B5G5R5A1_UNORM:
      func = &util_format_b5g5r5a1_unorm_pack_4f;
      break;
   case PIPE_FORMAT_B4G4R4A4_UNORM:
      func = &util_format_b4g4r4a4_unorm_pack_4f;
      break;
   case PIPE_FORMAT_B5G6R5_UNORM:
      func = &util_format_b5g6r5_unorm_pack_4f;
      break;
   case PIPE_FORMAT_R10G10B10A2_UNORM:
      func = &util_format_r10g10b10a2_unorm_pack_4f;
      break;
   case PIPE_FORMAT_L8_UNORM:
      func = &util_format_l8_unorm_pack_4f;
      break;
   case PIPE_FORMAT_A8_UNORM:
      func = &util_format_a8_unorm_pack_4f;
      break;
   case PIPE_FORMAT_I8_UNORM:
      func = &util_format_i8_unorm_pack_4f;
      break;
   case PIPE_FORMAT_L8A8_UNORM:
      func = &util_format_l8a8_unorm_pack_4f;
      break;
   case PIPE_FORMAT_L16_UNORM:
      func = &util_format_l16_unorm_pack_4f;
      break;
   case PIPE_FORMAT_L8_SRGB:
      func = &util_format_l8_srgb_pack_4f;
      break;
   case PIPE_FORMAT_L8A8_SRGB:
      func = &util_format_l8a8_srgb_pack_4f;
      break;
   case PIPE_FORMAT_R8G8B8_SRGB:
      func = &util_format_r8g8b8_srgb_pack_4f;
      break;
   case PIPE_FORMAT_A8B8G8R8_SRGB:
      func = &util_format_a8b8g8r8_srgb_pack_4f;
      break;
   case PIPE_FORMAT_X8B8G8R8_SRGB:
      func = &util_format_x8b8g8r8_srgb_pack_4f;
      break;
   case PIPE_FORMAT_B8G8R8A8_SRGB:
      func = &util_format_b8g8r8a8_srgb_pack_4f;
      break;
   case PIPE_FORMAT_B8G8R8X8_SRGB:
      func = &util_format_b8g8r8x8_srgb_pack_4f;
      break;
   case PIPE_FORMAT_A8R8G8B8_SRGB:
      func = &util_format_a8r8g8b8_srgb_pack_4f;
      break;
   case PIPE_FORMAT_X8R8G8B8_SRGB:
      func = &util_format_x8r8g8b8_srgb_pack_4f;
      break;
   case PIPE_FORMAT_R8SG8SB8UX8U_NORM:
      func = &util_format_r8sg8sb8ux8u_norm_pack_4f;
      break;
   case PIPE_FORMAT_R5SG5SB6U_NORM:
      func = &util_format_r5sg5sb6u_norm_pack_4f;
      break;
   case PIPE_FORMAT_Z16_UNORM:
      func = &util_format_z16_unorm_pack_4f;
      break;
   case PIPE_FORMAT_Z32_UNORM:
      func = &util_format_z32_unorm_pack_4f;
      break;
   case PIPE_FORMAT_Z32_FLOAT:
      func = &util_format_z32_float_pack_4f;
      break;
   case PIPE_FORMAT_Z24S8_UNORM:
      func = &util_format_z24s8_unorm_pack_4f;
      break;
   case PIPE_FORMAT_S8Z24_UNORM:
      func = &util_format_s8z24_unorm_pack_4f;
      break;
   case PIPE_FORMAT_Z24X8_UNORM:
      func = &util_format_z24x8_unorm_pack_4f;
      break;
   case PIPE_FORMAT_X8Z24_UNORM:
      func = &util_format_x8z24_unorm_pack_4f;
      break;
   case PIPE_FORMAT_R64_FLOAT:
      func = &util_format_r64_float_pack_4f;
      break;
   case PIPE_FORMAT_R64G64_FLOAT:
      func = &util_format_r64g64_float_pack_4f;
      break;
   case PIPE_FORMAT_R64G64B64_FLOAT:
      func = &util_format_r64g64b64_float_pack_4f;
      break;
   case PIPE_FORMAT_R64G64B64A64_FLOAT:
      func = &util_format_r64g64b64a64_float_pack_4f;
      break;
   case PIPE_FORMAT_R32_FLOAT:
      func = &util_format_r32_float_pack_4f;
      break;
   case PIPE_FORMAT_R32G32_FLOAT:
      func = &util_format_r32g32_float_pack_4f;
      break;
   case PIPE_FORMAT_R32G32B32_FLOAT:
      func = &util_format_r32g32b32_float_pack_4f;
      break;
   case PIPE_FORMAT_R32G32B32A32_FLOAT:
      func = &util_format_r32g32b32a32_float_pack_4f;
      break;
   case PIPE_FORMAT_R32_UNORM:
      func = &util_format_r32_unorm_pack_4f;
      break;
   case PIPE_FORMAT_R32G32_UNORM:
      func = &util_format_r32g32_unorm_pack_4f;
      break;
   case PIPE_FORMAT_R32G32B32_UNORM:
      func = &util_format_r32g32b32_unorm_pack_4f;
      break;
   case PIPE_FORMAT_R32G32B32A32_UNORM:
      func = &util_format_r32g32b32a32_unorm_pack_4f;
      break;
   case PIPE_FORMAT_R32_USCALED:
      func = &util_format_r32_uscaled_pack_4f;
      break;
   case PIPE_FORMAT_R32G32_USCALED:
      func = &util_format_r32g32_uscaled_pack_4f;
      break;
   case PIPE_FORMAT_R32G32B32_USCALED:
      func = &util_format_r32g32b32_uscaled_pack_4f;
      break;
   case PIPE_FORMAT_R32G32B32A32_USCALED:
      func = &util_format_r32g32b32a32_uscaled_pack_4f;
      break;
   case PIPE_FORMAT_R32_SNORM:
      func = &util_format_r32_snorm_pack_4f;
      break;
   case PIPE_FORMAT_R32G32_SNORM:
      func = &util_format_r32g32_snorm_pack_4f;
      break;
   case PIPE_FORMAT_R32G32B32_SNORM:
      func = &util_format_r32g32b32_snorm_pack_4f;
      break;
   case PIPE_FORMAT_R32G32B32A32_SNORM:
      func = &util_format_r32g32b32a32_snorm_pack_4f;
      break;
   case PIPE_FORMAT_R32_SSCALED:
      func = &util_format_r32_sscaled_pack_4f;
      break;
   case PIPE_FORMAT_R32G32_SSCALED:
      func = &util_format_r32g32_sscaled_pack_4f;
      break;
   case PIPE_FORMAT_R32G32B32_SSCALED:
      func = &util_format_r32g32b32_sscaled_pack_4f;
      break;
   case PIPE_FORMAT_R32G32B32A32_SSCALED:
      func = &util_format_r32g32b32a32_sscaled_pack_4f;
      break;
   case PIPE_FORMAT_R16_UNORM:
      func = &util_format_r16_unorm_pack_4f;
      break;
   case PIPE_FORMAT_R16G16_UNORM:
      func = &util_format_r16g16_unorm_pack_4f;
      break;
   case PIPE_FORMAT_R16G16B16_UNORM:
      func = &util_format_r16g16b16_unorm_pack_4f;
      break;
   case PIPE_FORMAT_R16G16B16A16_UNORM:
      func = &util_format_r16g16b16a16_unorm_pack_4f;
      break;
   case PIPE_FORMAT_R16_USCALED:
      func = &util_format_r16_uscaled_pack_4f;
      break;
   case PIPE_FORMAT_R16G16_USCALED:
      func = &util_format_r16g16_uscaled_pack_4f;
      break;
   case PIPE_FORMAT_R16G16B16_USCALED:
      func = &util_format_r16g16b16_uscaled_pack_4f;
      break;
   case PIPE_FORMAT_R16G16B16A16_USCALED:
      func = &util_format_r16g16b16a16_uscaled_pack_4f;
      break;
   case PIPE_FORMAT_R16_SNORM:
      func = &util_format_r16_snorm_pack_4f;
      break;
   case PIPE_FORMAT_R16G16_SNORM:
      func = &util_format_r16g16_snorm_pack_4f;
      break;
   case PIPE_FORMAT_R16G16B16_SNORM:
      func = &util_format_r16g16b16_snorm_pack_4f;
      break;
   case PIPE_FORMAT_R16G16B16A16_SNORM:
      func = &util_format_r16g16b16a16_snorm_pack_4f;
      break;
   case PIPE_FORMAT_R16_SSCALED:
      func = &util_format_r16_sscaled_pack_4f;
      break;
   case PIPE_FORMAT_R16G16_SSCALED:
      func = &util_format_r16g16_sscaled_pack_4f;
      break;
   case PIPE_FORMAT_R16G16B16_SSCALED:
      func = &util_format_r16g16b16_sscaled_pack_4f;
      break;
   case PIPE_FORMAT_R16G16B16A16_SSCALED:
      func = &util_format_r16g16b16a16_sscaled_pack_4f;
      break;
   case PIPE_FORMAT_R8_UNORM:
      func = &util_format_r8_unorm_pack_4f;
      break;
   case PIPE_FORMAT_R8G8_UNORM:
      func = &util_format_r8g8_unorm_pack_4f;
      break;
   case PIPE_FORMAT_R8G8B8_UNORM:
      func = &util_format_r8g8b8_unorm_pack_4f;
      break;
   case PIPE_FORMAT_R8G8B8A8_UNORM:
      func = &util_format_r8g8b8a8_unorm_pack_4f;
      break;
   case PIPE_FORMAT_R8_USCALED:
      func = &util_format_r8_uscaled_pack_4f;
      break;
   case PIPE_FORMAT_R8G8_USCALED:
      func = &util_format_r8g8_uscaled_pack_4f;
      break;
   case PIPE_FORMAT_R8G8B8_USCALED:
      func = &util_format_r8g8b8_uscaled_pack_4f;
      break;
   case PIPE_FORMAT_R8G8B8A8_USCALED:
      func = &util_format_r8g8b8a8_uscaled_pack_4f;
      break;
   case PIPE_FORMAT_R8_SNORM:
      func = &util_format_r8_snorm_pack_4f;
      break;
   case PIPE_FORMAT_R8G8_SNORM:
      func = &util_format_r8g8_snorm_pack_4f;
      break;
   case PIPE_FORMAT_R8G8B8_SNORM:
      func = &util_format_r8g8b8_snorm_pack_4f;
      break;
   case PIPE_FORMAT_R8G8B8A8_SNORM:
      func = &util_format_r8g8b8a8_snorm_pack_4f;
      break;
   case PIPE_FORMAT_R8_SSCALED:
      func = &util_format_r8_sscaled_pack_4f;
      break;
   case PIPE_FORMAT_R8G8_SSCALED:
      func = &util_format_r8g8_sscaled_pack_4f;
      break;
   case PIPE_FORMAT_R8G8B8_SSCALED:
      func = &util_format_r8g8b8_sscaled_pack_4f;
      break;
   case PIPE_FORMAT_R8G8B8A8_SSCALED:
      func = &util_format_r8g8b8a8_sscaled_pack_4f;
      break;
   default:
      debug_printf("%s: unsupported format\n", __FUNCTION__);
      return;
   }
   func(dst, r, g, b, a);
}

static INLINE void
util_format_b8g8r8a8_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_b8g8r8a8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = pixel.chan.a; /* a */
}

static INLINE void
util_format_b8g8r8x8_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_b8g8r8x8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_a8r8g8b8_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_a8r8g8b8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = pixel.chan.a; /* a */
}

static INLINE void
util_format_x8r8g8b8_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_x8r8g8b8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_a8b8g8r8_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_a8b8g8r8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = pixel.chan.a; /* a */
}

static INLINE void
util_format_x8b8g8r8_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_x8b8g8r8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_b5g5r5a1_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_b5g5r5a1_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap16(pixel.value);
#endif
   dst[0] = (uint8_t)((uint32_t)pixel.chan.r * 0xff / 0x1f); /* r */
   dst[1] = (uint8_t)((uint32_t)pixel.chan.g * 0xff / 0x1f); /* g */
   dst[2] = (uint8_t)((uint32_t)pixel.chan.b * 0xff / 0x1f); /* b */
   dst[3] = (uint8_t)((uint32_t)pixel.chan.a * 0xff / 0x1); /* a */
}

static INLINE void
util_format_b4g4r4a4_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_b4g4r4a4_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap16(pixel.value);
#endif
   dst[0] = (uint8_t)((uint32_t)pixel.chan.r * 0xff / 0xf); /* r */
   dst[1] = (uint8_t)((uint32_t)pixel.chan.g * 0xff / 0xf); /* g */
   dst[2] = (uint8_t)((uint32_t)pixel.chan.b * 0xff / 0xf); /* b */
   dst[3] = (uint8_t)((uint32_t)pixel.chan.a * 0xff / 0xf); /* a */
}

static INLINE void
util_format_b5g6r5_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_b5g6r5_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap16(pixel.value);
#endif
   dst[0] = (uint8_t)((uint32_t)pixel.chan.r * 0xff / 0x1f); /* r */
   dst[1] = (uint8_t)((uint32_t)pixel.chan.g * 0xff / 0x3f); /* g */
   dst[2] = (uint8_t)((uint32_t)pixel.chan.b * 0xff / 0x1f); /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r10g10b10a2_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r10g10b10a2_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   dst[0] = (uint8_t)(pixel.chan.r >> 2); /* r */
   dst[1] = (uint8_t)(pixel.chan.g >> 2); /* g */
   dst[2] = (uint8_t)(pixel.chan.b >> 2); /* b */
   dst[3] = (uint8_t)((uint32_t)pixel.chan.a * 0xff / 0x3); /* a */
}

static INLINE void
util_format_l8_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_l8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.rgb; /* r */
   dst[1] = pixel.chan.rgb; /* g */
   dst[2] = pixel.chan.rgb; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_a8_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_a8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = 0; /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = pixel.chan.a; /* a */
}

static INLINE void
util_format_i8_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_i8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.rgba; /* r */
   dst[1] = pixel.chan.rgba; /* g */
   dst[2] = pixel.chan.rgba; /* b */
   dst[3] = pixel.chan.rgba; /* a */
}

static INLINE void
util_format_l8a8_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_l8a8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.rgb; /* r */
   dst[1] = pixel.chan.rgb; /* g */
   dst[2] = pixel.chan.rgb; /* b */
   dst[3] = pixel.chan.a; /* a */
}

static INLINE void
util_format_l16_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_l16_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(pixel.chan.rgb >> 8); /* r */
   dst[1] = (uint8_t)(pixel.chan.rgb >> 8); /* g */
   dst[2] = (uint8_t)(pixel.chan.rgb >> 8); /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_l8_srgb_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_l8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.rgb; /* r */
   dst[1] = pixel.chan.rgb; /* g */
   dst[2] = pixel.chan.rgb; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_l8a8_srgb_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_l8a8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.rgb; /* r */
   dst[1] = pixel.chan.rgb; /* g */
   dst[2] = pixel.chan.rgb; /* b */
   dst[3] = pixel.chan.a; /* a */
}

static INLINE void
util_format_r8g8b8_srgb_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8g8b8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_a8b8g8r8_srgb_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_a8b8g8r8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = pixel.chan.a; /* a */
}

static INLINE void
util_format_x8b8g8r8_srgb_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_x8b8g8r8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_b8g8r8a8_srgb_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_b8g8r8a8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = pixel.chan.a; /* a */
}

static INLINE void
util_format_b8g8r8x8_srgb_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_b8g8r8x8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_a8r8g8b8_srgb_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_a8r8g8b8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = pixel.chan.a; /* a */
}

static INLINE void
util_format_x8r8g8b8_srgb_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_x8r8g8b8_srgb pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r8sg8sb8ux8u_norm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8sg8sb8ux8u_norm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)MAX2(pixel.chan.r, 0) * 0xff / 0x7f); /* r */
   dst[1] = (uint8_t)((uint32_t)MAX2(pixel.chan.g, 0) * 0xff / 0x7f); /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r5sg5sb6u_norm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r5sg5sb6u_norm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap16(pixel.value);
#endif
   dst[0] = (uint8_t)((uint32_t)MAX2(pixel.chan.r, 0) * 0xff / 0xf); /* r */
   dst[1] = (uint8_t)((uint32_t)MAX2(pixel.chan.g, 0) * 0xff / 0xf); /* g */
   dst[2] = (uint8_t)((uint32_t)pixel.chan.b * 0xff / 0x3f); /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_z16_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_z16_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(pixel.chan.z >> 8); /* r */
   dst[1] = dst[0]; /* g */
   dst[2] = dst[0]; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_z32_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_z32_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(pixel.chan.z >> 24); /* r */
   dst[1] = dst[0]; /* g */
   dst[2] = dst[0]; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_z32_float_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_z32_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(CLAMP(pixel.chan.z, 0, 1) * 0xff); /* r */
   dst[1] = dst[0]; /* g */
   dst[2] = dst[0]; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_z24s8_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_z24s8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   dst[0] = (uint8_t)(pixel.chan.z >> 16); /* r */
   dst[1] = dst[0]; /* g */
   dst[2] = dst[0]; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_s8z24_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_s8z24_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   dst[0] = (uint8_t)(pixel.chan.z >> 16); /* r */
   dst[1] = dst[0]; /* g */
   dst[2] = dst[0]; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_z24x8_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_z24x8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   dst[0] = (uint8_t)(pixel.chan.z >> 16); /* r */
   dst[1] = dst[0]; /* g */
   dst[2] = dst[0]; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_x8z24_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_x8z24_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   dst[0] = (uint8_t)(pixel.chan.z >> 16); /* r */
   dst[1] = dst[0]; /* g */
   dst[2] = dst[0]; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r64_float_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r64_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(CLAMP(pixel.chan.r, 0, 1) * 0xff); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r64g64_float_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r64g64_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(CLAMP(pixel.chan.r, 0, 1) * 0xff); /* r */
   dst[1] = (uint8_t)(CLAMP(pixel.chan.g, 0, 1) * 0xff); /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r64g64b64_float_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r64g64b64_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(CLAMP(pixel.chan.r, 0, 1) * 0xff); /* r */
   dst[1] = (uint8_t)(CLAMP(pixel.chan.g, 0, 1) * 0xff); /* g */
   dst[2] = (uint8_t)(CLAMP(pixel.chan.b, 0, 1) * 0xff); /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r64g64b64a64_float_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r64g64b64a64_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(CLAMP(pixel.chan.r, 0, 1) * 0xff); /* r */
   dst[1] = (uint8_t)(CLAMP(pixel.chan.g, 0, 1) * 0xff); /* g */
   dst[2] = (uint8_t)(CLAMP(pixel.chan.b, 0, 1) * 0xff); /* b */
   dst[3] = (uint8_t)(CLAMP(pixel.chan.a, 0, 1) * 0xff); /* a */
}

static INLINE void
util_format_r32_float_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(CLAMP(pixel.chan.r, 0, 1) * 0xff); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r32g32_float_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32g32_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(CLAMP(pixel.chan.r, 0, 1) * 0xff); /* r */
   dst[1] = (uint8_t)(CLAMP(pixel.chan.g, 0, 1) * 0xff); /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r32g32b32_float_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32g32b32_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(CLAMP(pixel.chan.r, 0, 1) * 0xff); /* r */
   dst[1] = (uint8_t)(CLAMP(pixel.chan.g, 0, 1) * 0xff); /* g */
   dst[2] = (uint8_t)(CLAMP(pixel.chan.b, 0, 1) * 0xff); /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r32g32b32a32_float_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32g32b32a32_float pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(CLAMP(pixel.chan.r, 0, 1) * 0xff); /* r */
   dst[1] = (uint8_t)(CLAMP(pixel.chan.g, 0, 1) * 0xff); /* g */
   dst[2] = (uint8_t)(CLAMP(pixel.chan.b, 0, 1) * 0xff); /* b */
   dst[3] = (uint8_t)(CLAMP(pixel.chan.a, 0, 1) * 0xff); /* a */
}

static INLINE void
util_format_r32_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(pixel.chan.r >> 24); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r32g32_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32g32_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(pixel.chan.r >> 24); /* r */
   dst[1] = (uint8_t)(pixel.chan.g >> 24); /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r32g32b32_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32g32b32_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(pixel.chan.r >> 24); /* r */
   dst[1] = (uint8_t)(pixel.chan.g >> 24); /* g */
   dst[2] = (uint8_t)(pixel.chan.b >> 24); /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r32g32b32a32_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32g32b32a32_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(pixel.chan.r >> 24); /* r */
   dst[1] = (uint8_t)(pixel.chan.g >> 24); /* g */
   dst[2] = (uint8_t)(pixel.chan.b >> 24); /* b */
   dst[3] = (uint8_t)(pixel.chan.a >> 24); /* a */
}

static INLINE void
util_format_r32_uscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint64_t)MIN2(pixel.chan.r, 1) * 0xff / 0x1); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r32g32_uscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32g32_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint64_t)MIN2(pixel.chan.r, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint64_t)MIN2(pixel.chan.g, 1) * 0xff / 0x1); /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r32g32b32_uscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32g32b32_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint64_t)MIN2(pixel.chan.r, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint64_t)MIN2(pixel.chan.g, 1) * 0xff / 0x1); /* g */
   dst[2] = (uint8_t)((uint64_t)MIN2(pixel.chan.b, 1) * 0xff / 0x1); /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r32g32b32a32_uscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32g32b32a32_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint64_t)MIN2(pixel.chan.r, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint64_t)MIN2(pixel.chan.g, 1) * 0xff / 0x1); /* g */
   dst[2] = (uint8_t)((uint64_t)MIN2(pixel.chan.b, 1) * 0xff / 0x1); /* b */
   dst[3] = (uint8_t)((uint64_t)MIN2(pixel.chan.a, 1) * 0xff / 0x1); /* a */
}

static INLINE void
util_format_r32_snorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 23); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r32g32_snorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32g32_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 23); /* r */
   dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 23); /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r32g32b32_snorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32g32b32_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 23); /* r */
   dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 23); /* g */
   dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 23); /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r32g32b32a32_snorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32g32b32a32_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 23); /* r */
   dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 23); /* g */
   dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 23); /* b */
   dst[3] = (uint8_t)(MAX2(pixel.chan.a, 0) >> 23); /* a */
}

static INLINE void
util_format_r32_sscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint64_t)CLAMP(pixel.chan.r, 0, 1) * 0xff / 0x1); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r32g32_sscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32g32_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint64_t)CLAMP(pixel.chan.r, 0, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint64_t)CLAMP(pixel.chan.g, 0, 1) * 0xff / 0x1); /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r32g32b32_sscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32g32b32_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint64_t)CLAMP(pixel.chan.r, 0, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint64_t)CLAMP(pixel.chan.g, 0, 1) * 0xff / 0x1); /* g */
   dst[2] = (uint8_t)((uint64_t)CLAMP(pixel.chan.b, 0, 1) * 0xff / 0x1); /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r32g32b32a32_sscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r32g32b32a32_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint64_t)CLAMP(pixel.chan.r, 0, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint64_t)CLAMP(pixel.chan.g, 0, 1) * 0xff / 0x1); /* g */
   dst[2] = (uint8_t)((uint64_t)CLAMP(pixel.chan.b, 0, 1) * 0xff / 0x1); /* b */
   dst[3] = (uint8_t)((uint64_t)CLAMP(pixel.chan.a, 0, 1) * 0xff / 0x1); /* a */
}

static INLINE void
util_format_r16_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r16_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(pixel.chan.r >> 8); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r16g16_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r16g16_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(pixel.chan.r >> 8); /* r */
   dst[1] = (uint8_t)(pixel.chan.g >> 8); /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r16g16b16_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r16g16b16_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(pixel.chan.r >> 8); /* r */
   dst[1] = (uint8_t)(pixel.chan.g >> 8); /* g */
   dst[2] = (uint8_t)(pixel.chan.b >> 8); /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r16g16b16a16_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r16g16b16a16_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(pixel.chan.r >> 8); /* r */
   dst[1] = (uint8_t)(pixel.chan.g >> 8); /* g */
   dst[2] = (uint8_t)(pixel.chan.b >> 8); /* b */
   dst[3] = (uint8_t)(pixel.chan.a >> 8); /* a */
}

static INLINE void
util_format_r16_uscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r16_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)MIN2(pixel.chan.r, 1) * 0xff / 0x1); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r16g16_uscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r16g16_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)MIN2(pixel.chan.r, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint32_t)MIN2(pixel.chan.g, 1) * 0xff / 0x1); /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r16g16b16_uscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r16g16b16_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)MIN2(pixel.chan.r, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint32_t)MIN2(pixel.chan.g, 1) * 0xff / 0x1); /* g */
   dst[2] = (uint8_t)((uint32_t)MIN2(pixel.chan.b, 1) * 0xff / 0x1); /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r16g16b16a16_uscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r16g16b16a16_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)MIN2(pixel.chan.r, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint32_t)MIN2(pixel.chan.g, 1) * 0xff / 0x1); /* g */
   dst[2] = (uint8_t)((uint32_t)MIN2(pixel.chan.b, 1) * 0xff / 0x1); /* b */
   dst[3] = (uint8_t)((uint32_t)MIN2(pixel.chan.a, 1) * 0xff / 0x1); /* a */
}

static INLINE void
util_format_r16_snorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r16_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 7); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r16g16_snorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r16g16_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 7); /* r */
   dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 7); /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r16g16b16_snorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r16g16b16_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 7); /* r */
   dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 7); /* g */
   dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 7); /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r16g16b16a16_snorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r16g16b16a16_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 7); /* r */
   dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 7); /* g */
   dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 7); /* b */
   dst[3] = (uint8_t)(MAX2(pixel.chan.a, 0) >> 7); /* a */
}

static INLINE void
util_format_r16_sscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r16_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)CLAMP(pixel.chan.r, 0, 1) * 0xff / 0x1); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r16g16_sscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r16g16_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)CLAMP(pixel.chan.r, 0, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint32_t)CLAMP(pixel.chan.g, 0, 1) * 0xff / 0x1); /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r16g16b16_sscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r16g16b16_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)CLAMP(pixel.chan.r, 0, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint32_t)CLAMP(pixel.chan.g, 0, 1) * 0xff / 0x1); /* g */
   dst[2] = (uint8_t)((uint32_t)CLAMP(pixel.chan.b, 0, 1) * 0xff / 0x1); /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r16g16b16a16_sscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r16g16b16a16_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)CLAMP(pixel.chan.r, 0, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint32_t)CLAMP(pixel.chan.g, 0, 1) * 0xff / 0x1); /* g */
   dst[2] = (uint8_t)((uint32_t)CLAMP(pixel.chan.b, 0, 1) * 0xff / 0x1); /* b */
   dst[3] = (uint8_t)((uint32_t)CLAMP(pixel.chan.a, 0, 1) * 0xff / 0x1); /* a */
}

static INLINE void
util_format_r8_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r8g8_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8g8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r8g8b8_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8g8b8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r8g8b8a8_unorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8g8b8a8_unorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = pixel.chan.r; /* r */
   dst[1] = pixel.chan.g; /* g */
   dst[2] = pixel.chan.b; /* b */
   dst[3] = pixel.chan.a; /* a */
}

static INLINE void
util_format_r8_uscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)MIN2(pixel.chan.r, 1) * 0xff / 0x1); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r8g8_uscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8g8_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)MIN2(pixel.chan.r, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint32_t)MIN2(pixel.chan.g, 1) * 0xff / 0x1); /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r8g8b8_uscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8g8b8_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)MIN2(pixel.chan.r, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint32_t)MIN2(pixel.chan.g, 1) * 0xff / 0x1); /* g */
   dst[2] = (uint8_t)((uint32_t)MIN2(pixel.chan.b, 1) * 0xff / 0x1); /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r8g8b8a8_uscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8g8b8a8_uscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)MIN2(pixel.chan.r, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint32_t)MIN2(pixel.chan.g, 1) * 0xff / 0x1); /* g */
   dst[2] = (uint8_t)((uint32_t)MIN2(pixel.chan.b, 1) * 0xff / 0x1); /* b */
   dst[3] = (uint8_t)((uint32_t)MIN2(pixel.chan.a, 1) * 0xff / 0x1); /* a */
}

static INLINE void
util_format_r8_snorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)MAX2(pixel.chan.r, 0) * 0xff / 0x7f); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r8g8_snorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8g8_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)MAX2(pixel.chan.r, 0) * 0xff / 0x7f); /* r */
   dst[1] = (uint8_t)((uint32_t)MAX2(pixel.chan.g, 0) * 0xff / 0x7f); /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r8g8b8_snorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8g8b8_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)MAX2(pixel.chan.r, 0) * 0xff / 0x7f); /* r */
   dst[1] = (uint8_t)((uint32_t)MAX2(pixel.chan.g, 0) * 0xff / 0x7f); /* g */
   dst[2] = (uint8_t)((uint32_t)MAX2(pixel.chan.b, 0) * 0xff / 0x7f); /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r8g8b8a8_snorm_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8g8b8a8_snorm pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)MAX2(pixel.chan.r, 0) * 0xff / 0x7f); /* r */
   dst[1] = (uint8_t)((uint32_t)MAX2(pixel.chan.g, 0) * 0xff / 0x7f); /* g */
   dst[2] = (uint8_t)((uint32_t)MAX2(pixel.chan.b, 0) * 0xff / 0x7f); /* b */
   dst[3] = (uint8_t)((uint32_t)MAX2(pixel.chan.a, 0) * 0xff / 0x7f); /* a */
}

static INLINE void
util_format_r8_sscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)CLAMP(pixel.chan.r, 0, 1) * 0xff / 0x1); /* r */
   dst[1] = 0; /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r8g8_sscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8g8_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)CLAMP(pixel.chan.r, 0, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint32_t)CLAMP(pixel.chan.g, 0, 1) * 0xff / 0x1); /* g */
   dst[2] = 0; /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r8g8b8_sscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8g8b8_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)CLAMP(pixel.chan.r, 0, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint32_t)CLAMP(pixel.chan.g, 0, 1) * 0xff / 0x1); /* g */
   dst[2] = (uint8_t)((uint32_t)CLAMP(pixel.chan.b, 0, 1) * 0xff / 0x1); /* b */
   dst[3] = 255; /* a */
}

static INLINE void
util_format_r8g8b8a8_sscaled_unpack_4ub(uint8_t *dst, const void *src)
{
   union util_format_r8g8b8a8_sscaled pixel;
   memcpy(&pixel, src, sizeof pixel);
   dst[0] = (uint8_t)((uint32_t)CLAMP(pixel.chan.r, 0, 1) * 0xff / 0x1); /* r */
   dst[1] = (uint8_t)((uint32_t)CLAMP(pixel.chan.g, 0, 1) * 0xff / 0x1); /* g */
   dst[2] = (uint8_t)((uint32_t)CLAMP(pixel.chan.b, 0, 1) * 0xff / 0x1); /* b */
   dst[3] = (uint8_t)((uint32_t)CLAMP(pixel.chan.a, 0, 1) * 0xff / 0x1); /* a */
}

static INLINE void
util_format_unpack_4ub(enum pipe_format format, uint8_t *dst, const void *src)
{
   void (*func)(uint8_t *dst, const void *src);
   switch(format) {
   case PIPE_FORMAT_B8G8R8A8_UNORM:
      func = &util_format_b8g8r8a8_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_B8G8R8X8_UNORM:
      func = &util_format_b8g8r8x8_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_A8R8G8B8_UNORM:
      func = &util_format_a8r8g8b8_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_X8R8G8B8_UNORM:
      func = &util_format_x8r8g8b8_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_A8B8G8R8_UNORM:
      func = &util_format_a8b8g8r8_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_X8B8G8R8_UNORM:
      func = &util_format_x8b8g8r8_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_B5G5R5A1_UNORM:
      func = &util_format_b5g5r5a1_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_B4G4R4A4_UNORM:
      func = &util_format_b4g4r4a4_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_B5G6R5_UNORM:
      func = &util_format_b5g6r5_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R10G10B10A2_UNORM:
      func = &util_format_r10g10b10a2_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_L8_UNORM:
      func = &util_format_l8_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_A8_UNORM:
      func = &util_format_a8_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_I8_UNORM:
      func = &util_format_i8_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_L8A8_UNORM:
      func = &util_format_l8a8_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_L16_UNORM:
      func = &util_format_l16_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_L8_SRGB:
      func = &util_format_l8_srgb_unpack_4ub;
      break;
   case PIPE_FORMAT_L8A8_SRGB:
      func = &util_format_l8a8_srgb_unpack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8_SRGB:
      func = &util_format_r8g8b8_srgb_unpack_4ub;
      break;
   case PIPE_FORMAT_A8B8G8R8_SRGB:
      func = &util_format_a8b8g8r8_srgb_unpack_4ub;
      break;
   case PIPE_FORMAT_X8B8G8R8_SRGB:
      func = &util_format_x8b8g8r8_srgb_unpack_4ub;
      break;
   case PIPE_FORMAT_B8G8R8A8_SRGB:
      func = &util_format_b8g8r8a8_srgb_unpack_4ub;
      break;
   case PIPE_FORMAT_B8G8R8X8_SRGB:
      func = &util_format_b8g8r8x8_srgb_unpack_4ub;
      break;
   case PIPE_FORMAT_A8R8G8B8_SRGB:
      func = &util_format_a8r8g8b8_srgb_unpack_4ub;
      break;
   case PIPE_FORMAT_X8R8G8B8_SRGB:
      func = &util_format_x8r8g8b8_srgb_unpack_4ub;
      break;
   case PIPE_FORMAT_R8SG8SB8UX8U_NORM:
      func = &util_format_r8sg8sb8ux8u_norm_unpack_4ub;
      break;
   case PIPE_FORMAT_R5SG5SB6U_NORM:
      func = &util_format_r5sg5sb6u_norm_unpack_4ub;
      break;
   case PIPE_FORMAT_Z16_UNORM:
      func = &util_format_z16_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_Z32_UNORM:
      func = &util_format_z32_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_Z32_FLOAT:
      func = &util_format_z32_float_unpack_4ub;
      break;
   case PIPE_FORMAT_Z24S8_UNORM:
      func = &util_format_z24s8_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_S8Z24_UNORM:
      func = &util_format_s8z24_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_Z24X8_UNORM:
      func = &util_format_z24x8_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_X8Z24_UNORM:
      func = &util_format_x8z24_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R64_FLOAT:
      func = &util_format_r64_float_unpack_4ub;
      break;
   case PIPE_FORMAT_R64G64_FLOAT:
      func = &util_format_r64g64_float_unpack_4ub;
      break;
   case PIPE_FORMAT_R64G64B64_FLOAT:
      func = &util_format_r64g64b64_float_unpack_4ub;
      break;
   case PIPE_FORMAT_R64G64B64A64_FLOAT:
      func = &util_format_r64g64b64a64_float_unpack_4ub;
      break;
   case PIPE_FORMAT_R32_FLOAT:
      func = &util_format_r32_float_unpack_4ub;
      break;
   case PIPE_FORMAT_R32G32_FLOAT:
      func = &util_format_r32g32_float_unpack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32_FLOAT:
      func = &util_format_r32g32b32_float_unpack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32A32_FLOAT:
      func = &util_format_r32g32b32a32_float_unpack_4ub;
      break;
   case PIPE_FORMAT_R32_UNORM:
      func = &util_format_r32_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R32G32_UNORM:
      func = &util_format_r32g32_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32_UNORM:
      func = &util_format_r32g32b32_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32A32_UNORM:
      func = &util_format_r32g32b32a32_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R32_USCALED:
      func = &util_format_r32_uscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R32G32_USCALED:
      func = &util_format_r32g32_uscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32_USCALED:
      func = &util_format_r32g32b32_uscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32A32_USCALED:
      func = &util_format_r32g32b32a32_uscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R32_SNORM:
      func = &util_format_r32_snorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R32G32_SNORM:
      func = &util_format_r32g32_snorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32_SNORM:
      func = &util_format_r32g32b32_snorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32A32_SNORM:
      func = &util_format_r32g32b32a32_snorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R32_SSCALED:
      func = &util_format_r32_sscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R32G32_SSCALED:
      func = &util_format_r32g32_sscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32_SSCALED:
      func = &util_format_r32g32b32_sscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32A32_SSCALED:
      func = &util_format_r32g32b32a32_sscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R16_UNORM:
      func = &util_format_r16_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R16G16_UNORM:
      func = &util_format_r16g16_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R16G16B16_UNORM:
      func = &util_format_r16g16b16_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R16G16B16A16_UNORM:
      func = &util_format_r16g16b16a16_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R16_USCALED:
      func = &util_format_r16_uscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R16G16_USCALED:
      func = &util_format_r16g16_uscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R16G16B16_USCALED:
      func = &util_format_r16g16b16_uscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R16G16B16A16_USCALED:
      func = &util_format_r16g16b16a16_uscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R16_SNORM:
      func = &util_format_r16_snorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R16G16_SNORM:
      func = &util_format_r16g16_snorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R16G16B16_SNORM:
      func = &util_format_r16g16b16_snorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R16G16B16A16_SNORM:
      func = &util_format_r16g16b16a16_snorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R16_SSCALED:
      func = &util_format_r16_sscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R16G16_SSCALED:
      func = &util_format_r16g16_sscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R16G16B16_SSCALED:
      func = &util_format_r16g16b16_sscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R16G16B16A16_SSCALED:
      func = &util_format_r16g16b16a16_sscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R8_UNORM:
      func = &util_format_r8_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R8G8_UNORM:
      func = &util_format_r8g8_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8_UNORM:
      func = &util_format_r8g8b8_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8A8_UNORM:
      func = &util_format_r8g8b8a8_unorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R8_USCALED:
      func = &util_format_r8_uscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R8G8_USCALED:
      func = &util_format_r8g8_uscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8_USCALED:
      func = &util_format_r8g8b8_uscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8A8_USCALED:
      func = &util_format_r8g8b8a8_uscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R8_SNORM:
      func = &util_format_r8_snorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R8G8_SNORM:
      func = &util_format_r8g8_snorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8_SNORM:
      func = &util_format_r8g8b8_snorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8A8_SNORM:
      func = &util_format_r8g8b8a8_snorm_unpack_4ub;
      break;
   case PIPE_FORMAT_R8_SSCALED:
      func = &util_format_r8_sscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R8G8_SSCALED:
      func = &util_format_r8g8_sscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8_SSCALED:
      func = &util_format_r8g8b8_sscaled_unpack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8A8_SSCALED:
      func = &util_format_r8g8b8a8_sscaled_unpack_4ub;
      break;
   default:
      debug_printf("unsupported format\n");
      return;
   }
   func(dst, src);
}

static INLINE void
util_format_b8g8r8a8_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_b8g8r8a8_unorm pixel;
   pixel.chan.b = b;
   pixel.chan.g = g;
   pixel.chan.r = r;
   pixel.chan.a = a;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_b8g8r8x8_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_b8g8r8x8_unorm pixel;
   pixel.chan.b = b;
   pixel.chan.g = g;
   pixel.chan.r = r;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_a8r8g8b8_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_a8r8g8b8_unorm pixel;
   pixel.chan.a = a;
   pixel.chan.r = r;
   pixel.chan.g = g;
   pixel.chan.b = b;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_x8r8g8b8_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_x8r8g8b8_unorm pixel;
   pixel.chan.r = r;
   pixel.chan.g = g;
   pixel.chan.b = b;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_a8b8g8r8_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_a8b8g8r8_unorm pixel;
   pixel.chan.a = a;
   pixel.chan.b = b;
   pixel.chan.g = g;
   pixel.chan.r = r;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_x8b8g8r8_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_x8b8g8r8_unorm pixel;
   pixel.chan.b = b;
   pixel.chan.g = g;
   pixel.chan.r = r;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_b5g5r5a1_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_b5g5r5a1_unorm pixel;
   pixel.chan.b = (uint16_t)(b >> 3);
   pixel.chan.g = (uint16_t)(g >> 3);
   pixel.chan.r = (uint16_t)(r >> 3);
   pixel.chan.a = (uint16_t)(a >> 7);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap16(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_b4g4r4a4_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_b4g4r4a4_unorm pixel;
   pixel.chan.b = (uint16_t)(b >> 4);
   pixel.chan.g = (uint16_t)(g >> 4);
   pixel.chan.r = (uint16_t)(r >> 4);
   pixel.chan.a = (uint16_t)(a >> 4);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap16(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_b5g6r5_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_b5g6r5_unorm pixel;
   pixel.chan.b = (uint16_t)(b >> 3);
   pixel.chan.g = (uint16_t)(g >> 2);
   pixel.chan.r = (uint16_t)(r >> 3);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap16(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r10g10b10a2_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r10g10b10a2_unorm pixel;
   pixel.chan.r = (uint32_t)((uint32_t)r * 0x3ff / 0xff);
   pixel.chan.g = (uint32_t)((uint32_t)g * 0x3ff / 0xff);
   pixel.chan.b = (uint32_t)((uint32_t)b * 0x3ff / 0xff);
   pixel.chan.a = (uint32_t)(a >> 6);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_l8_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_l8_unorm pixel;
   pixel.chan.rgb = b;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_a8_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_a8_unorm pixel;
   pixel.chan.a = a;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_i8_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_i8_unorm pixel;
   pixel.chan.rgba = a;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_l8a8_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_l8a8_unorm pixel;
   pixel.chan.rgb = b;
   pixel.chan.a = a;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_l16_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_l16_unorm pixel;
   pixel.chan.rgb = (uint16_t)((uint32_t)b * 0xffff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_l8_srgb_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_l8_srgb pixel;
   pixel.chan.rgb = b;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_l8a8_srgb_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_l8a8_srgb pixel;
   pixel.chan.rgb = b;
   pixel.chan.a = a;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8_srgb_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8g8b8_srgb pixel;
   pixel.chan.r = r;
   pixel.chan.g = g;
   pixel.chan.b = b;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_a8b8g8r8_srgb_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_a8b8g8r8_srgb pixel;
   pixel.chan.a = a;
   pixel.chan.b = b;
   pixel.chan.g = g;
   pixel.chan.r = r;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_x8b8g8r8_srgb_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_x8b8g8r8_srgb pixel;
   pixel.chan.b = b;
   pixel.chan.g = g;
   pixel.chan.r = r;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_b8g8r8a8_srgb_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_b8g8r8a8_srgb pixel;
   pixel.chan.b = b;
   pixel.chan.g = g;
   pixel.chan.r = r;
   pixel.chan.a = a;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_b8g8r8x8_srgb_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_b8g8r8x8_srgb pixel;
   pixel.chan.b = b;
   pixel.chan.g = g;
   pixel.chan.r = r;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_a8r8g8b8_srgb_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_a8r8g8b8_srgb pixel;
   pixel.chan.a = a;
   pixel.chan.r = r;
   pixel.chan.g = g;
   pixel.chan.b = b;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_x8r8g8b8_srgb_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_x8r8g8b8_srgb pixel;
   pixel.chan.r = r;
   pixel.chan.g = g;
   pixel.chan.b = b;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8sg8sb8ux8u_norm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8sg8sb8ux8u_norm pixel;
   pixel.chan.r = (int8_t)(r >> 1);
   pixel.chan.g = (int8_t)(g >> 1);
   pixel.chan.b = b;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r5sg5sb6u_norm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r5sg5sb6u_norm pixel;
   pixel.chan.r = (uint16_t)(r >> 4);
   pixel.chan.g = (uint16_t)(g >> 4);
   pixel.chan.b = (uint16_t)(b >> 2);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap16(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_z16_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_z16_unorm pixel;
   pixel.chan.z = (uint16_t)((uint32_t)r * 0xffff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_z32_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_z32_unorm pixel;
   pixel.chan.z = (uint32_t)((uint64_t)r * 0xffffffff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_z32_float_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_z32_float pixel;
   pixel.chan.z = (float)(r * (1.0f/0xff));
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_z24s8_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_z24s8_unorm pixel;
   pixel.chan.z = (uint32_t)((uint32_t)r * 0xffffff / 0xff);
   pixel.chan.s = 0;
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_s8z24_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_s8z24_unorm pixel;
   pixel.chan.s = g;
   pixel.chan.z = 0;
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_z24x8_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_z24x8_unorm pixel;
   pixel.chan.z = (uint32_t)((uint32_t)r * 0xffffff / 0xff);
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_x8z24_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_x8z24_unorm pixel;
   pixel.chan.z = 0;
#ifdef PIPE_ARCH_BIG_ENDIAN
   pixel.value = util_bswap32(pixel.value);
#endif
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r64_float_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r64_float pixel;
   pixel.chan.r = (double)(r * (1.0f/0xff));
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r64g64_float_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r64g64_float pixel;
   pixel.chan.r = (double)(r * (1.0f/0xff));
   pixel.chan.g = (double)(g * (1.0f/0xff));
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r64g64b64_float_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r64g64b64_float pixel;
   pixel.chan.r = (double)(r * (1.0f/0xff));
   pixel.chan.g = (double)(g * (1.0f/0xff));
   pixel.chan.b = (double)(b * (1.0f/0xff));
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r64g64b64a64_float_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r64g64b64a64_float pixel;
   pixel.chan.r = (double)(r * (1.0f/0xff));
   pixel.chan.g = (double)(g * (1.0f/0xff));
   pixel.chan.b = (double)(b * (1.0f/0xff));
   pixel.chan.a = (double)(a * (1.0f/0xff));
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32_float_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32_float pixel;
   pixel.chan.r = (float)(r * (1.0f/0xff));
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32_float_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32g32_float pixel;
   pixel.chan.r = (float)(r * (1.0f/0xff));
   pixel.chan.g = (float)(g * (1.0f/0xff));
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32_float_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32g32b32_float pixel;
   pixel.chan.r = (float)(r * (1.0f/0xff));
   pixel.chan.g = (float)(g * (1.0f/0xff));
   pixel.chan.b = (float)(b * (1.0f/0xff));
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32a32_float_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32g32b32a32_float pixel;
   pixel.chan.r = (float)(r * (1.0f/0xff));
   pixel.chan.g = (float)(g * (1.0f/0xff));
   pixel.chan.b = (float)(b * (1.0f/0xff));
   pixel.chan.a = (float)(a * (1.0f/0xff));
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32_unorm pixel;
   pixel.chan.r = (uint32_t)((uint64_t)r * 0xffffffff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32g32_unorm pixel;
   pixel.chan.r = (uint32_t)((uint64_t)r * 0xffffffff / 0xff);
   pixel.chan.g = (uint32_t)((uint64_t)g * 0xffffffff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32g32b32_unorm pixel;
   pixel.chan.r = (uint32_t)((uint64_t)r * 0xffffffff / 0xff);
   pixel.chan.g = (uint32_t)((uint64_t)g * 0xffffffff / 0xff);
   pixel.chan.b = (uint32_t)((uint64_t)b * 0xffffffff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32a32_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32g32b32a32_unorm pixel;
   pixel.chan.r = (uint32_t)((uint64_t)r * 0xffffffff / 0xff);
   pixel.chan.g = (uint32_t)((uint64_t)g * 0xffffffff / 0xff);
   pixel.chan.b = (uint32_t)((uint64_t)b * 0xffffffff / 0xff);
   pixel.chan.a = (uint32_t)((uint64_t)a * 0xffffffff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32_uscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32_uscaled pixel;
   pixel.chan.r = (uint32_t)(r >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32_uscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32g32_uscaled pixel;
   pixel.chan.r = (uint32_t)(r >> 8);
   pixel.chan.g = (uint32_t)(g >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32_uscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32g32b32_uscaled pixel;
   pixel.chan.r = (uint32_t)(r >> 8);
   pixel.chan.g = (uint32_t)(g >> 8);
   pixel.chan.b = (uint32_t)(b >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32a32_uscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32g32b32a32_uscaled pixel;
   pixel.chan.r = (uint32_t)(r >> 8);
   pixel.chan.g = (uint32_t)(g >> 8);
   pixel.chan.b = (uint32_t)(b >> 8);
   pixel.chan.a = (uint32_t)(a >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32_snorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32_snorm pixel;
   pixel.chan.r = (int32_t)((uint64_t)r * 0x7fffffff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32_snorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32g32_snorm pixel;
   pixel.chan.r = (int32_t)((uint64_t)r * 0x7fffffff / 0xff);
   pixel.chan.g = (int32_t)((uint64_t)g * 0x7fffffff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32_snorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32g32b32_snorm pixel;
   pixel.chan.r = (int32_t)((uint64_t)r * 0x7fffffff / 0xff);
   pixel.chan.g = (int32_t)((uint64_t)g * 0x7fffffff / 0xff);
   pixel.chan.b = (int32_t)((uint64_t)b * 0x7fffffff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32a32_snorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32g32b32a32_snorm pixel;
   pixel.chan.r = (int32_t)((uint64_t)r * 0x7fffffff / 0xff);
   pixel.chan.g = (int32_t)((uint64_t)g * 0x7fffffff / 0xff);
   pixel.chan.b = (int32_t)((uint64_t)b * 0x7fffffff / 0xff);
   pixel.chan.a = (int32_t)((uint64_t)a * 0x7fffffff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32_sscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32_sscaled pixel;
   pixel.chan.r = (int32_t)(r >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32_sscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32g32_sscaled pixel;
   pixel.chan.r = (int32_t)(r >> 8);
   pixel.chan.g = (int32_t)(g >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32_sscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32g32b32_sscaled pixel;
   pixel.chan.r = (int32_t)(r >> 8);
   pixel.chan.g = (int32_t)(g >> 8);
   pixel.chan.b = (int32_t)(b >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r32g32b32a32_sscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r32g32b32a32_sscaled pixel;
   pixel.chan.r = (int32_t)(r >> 8);
   pixel.chan.g = (int32_t)(g >> 8);
   pixel.chan.b = (int32_t)(b >> 8);
   pixel.chan.a = (int32_t)(a >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r16_unorm pixel;
   pixel.chan.r = (uint16_t)((uint32_t)r * 0xffff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r16g16_unorm pixel;
   pixel.chan.r = (uint16_t)((uint32_t)r * 0xffff / 0xff);
   pixel.chan.g = (uint16_t)((uint32_t)g * 0xffff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16b16_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r16g16b16_unorm pixel;
   pixel.chan.r = (uint16_t)((uint32_t)r * 0xffff / 0xff);
   pixel.chan.g = (uint16_t)((uint32_t)g * 0xffff / 0xff);
   pixel.chan.b = (uint16_t)((uint32_t)b * 0xffff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16b16a16_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r16g16b16a16_unorm pixel;
   pixel.chan.r = (uint16_t)((uint32_t)r * 0xffff / 0xff);
   pixel.chan.g = (uint16_t)((uint32_t)g * 0xffff / 0xff);
   pixel.chan.b = (uint16_t)((uint32_t)b * 0xffff / 0xff);
   pixel.chan.a = (uint16_t)((uint32_t)a * 0xffff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16_uscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r16_uscaled pixel;
   pixel.chan.r = (uint16_t)(r >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16_uscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r16g16_uscaled pixel;
   pixel.chan.r = (uint16_t)(r >> 8);
   pixel.chan.g = (uint16_t)(g >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16b16_uscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r16g16b16_uscaled pixel;
   pixel.chan.r = (uint16_t)(r >> 8);
   pixel.chan.g = (uint16_t)(g >> 8);
   pixel.chan.b = (uint16_t)(b >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16b16a16_uscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r16g16b16a16_uscaled pixel;
   pixel.chan.r = (uint16_t)(r >> 8);
   pixel.chan.g = (uint16_t)(g >> 8);
   pixel.chan.b = (uint16_t)(b >> 8);
   pixel.chan.a = (uint16_t)(a >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16_snorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r16_snorm pixel;
   pixel.chan.r = (int16_t)((uint32_t)r * 0x7fff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16_snorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r16g16_snorm pixel;
   pixel.chan.r = (int16_t)((uint32_t)r * 0x7fff / 0xff);
   pixel.chan.g = (int16_t)((uint32_t)g * 0x7fff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16b16_snorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r16g16b16_snorm pixel;
   pixel.chan.r = (int16_t)((uint32_t)r * 0x7fff / 0xff);
   pixel.chan.g = (int16_t)((uint32_t)g * 0x7fff / 0xff);
   pixel.chan.b = (int16_t)((uint32_t)b * 0x7fff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16b16a16_snorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r16g16b16a16_snorm pixel;
   pixel.chan.r = (int16_t)((uint32_t)r * 0x7fff / 0xff);
   pixel.chan.g = (int16_t)((uint32_t)g * 0x7fff / 0xff);
   pixel.chan.b = (int16_t)((uint32_t)b * 0x7fff / 0xff);
   pixel.chan.a = (int16_t)((uint32_t)a * 0x7fff / 0xff);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16_sscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r16_sscaled pixel;
   pixel.chan.r = (int16_t)(r >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16_sscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r16g16_sscaled pixel;
   pixel.chan.r = (int16_t)(r >> 8);
   pixel.chan.g = (int16_t)(g >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16b16_sscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r16g16b16_sscaled pixel;
   pixel.chan.r = (int16_t)(r >> 8);
   pixel.chan.g = (int16_t)(g >> 8);
   pixel.chan.b = (int16_t)(b >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r16g16b16a16_sscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r16g16b16a16_sscaled pixel;
   pixel.chan.r = (int16_t)(r >> 8);
   pixel.chan.g = (int16_t)(g >> 8);
   pixel.chan.b = (int16_t)(b >> 8);
   pixel.chan.a = (int16_t)(a >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8_unorm pixel;
   pixel.chan.r = r;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8g8_unorm pixel;
   pixel.chan.r = r;
   pixel.chan.g = g;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8g8b8_unorm pixel;
   pixel.chan.r = r;
   pixel.chan.g = g;
   pixel.chan.b = b;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8a8_unorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8g8b8a8_unorm pixel;
   pixel.chan.r = r;
   pixel.chan.g = g;
   pixel.chan.b = b;
   pixel.chan.a = a;
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8_uscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8_uscaled pixel;
   pixel.chan.r = (uint8_t)(r >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8_uscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8g8_uscaled pixel;
   pixel.chan.r = (uint8_t)(r >> 8);
   pixel.chan.g = (uint8_t)(g >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8_uscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8g8b8_uscaled pixel;
   pixel.chan.r = (uint8_t)(r >> 8);
   pixel.chan.g = (uint8_t)(g >> 8);
   pixel.chan.b = (uint8_t)(b >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8a8_uscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8g8b8a8_uscaled pixel;
   pixel.chan.r = (uint8_t)(r >> 8);
   pixel.chan.g = (uint8_t)(g >> 8);
   pixel.chan.b = (uint8_t)(b >> 8);
   pixel.chan.a = (uint8_t)(a >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8_snorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8_snorm pixel;
   pixel.chan.r = (int8_t)(r >> 1);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8_snorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8g8_snorm pixel;
   pixel.chan.r = (int8_t)(r >> 1);
   pixel.chan.g = (int8_t)(g >> 1);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8_snorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8g8b8_snorm pixel;
   pixel.chan.r = (int8_t)(r >> 1);
   pixel.chan.g = (int8_t)(g >> 1);
   pixel.chan.b = (int8_t)(b >> 1);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8a8_snorm_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8g8b8a8_snorm pixel;
   pixel.chan.r = (int8_t)(r >> 1);
   pixel.chan.g = (int8_t)(g >> 1);
   pixel.chan.b = (int8_t)(b >> 1);
   pixel.chan.a = (int8_t)(a >> 1);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8_sscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8_sscaled pixel;
   pixel.chan.r = (int8_t)(r >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8_sscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8g8_sscaled pixel;
   pixel.chan.r = (int8_t)(r >> 8);
   pixel.chan.g = (int8_t)(g >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8_sscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8g8b8_sscaled pixel;
   pixel.chan.r = (int8_t)(r >> 8);
   pixel.chan.g = (int8_t)(g >> 8);
   pixel.chan.b = (int8_t)(b >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_r8g8b8a8_sscaled_pack_4ub(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   union util_format_r8g8b8a8_sscaled pixel;
   pixel.chan.r = (int8_t)(r >> 8);
   pixel.chan.g = (int8_t)(g >> 8);
   pixel.chan.b = (int8_t)(b >> 8);
   pixel.chan.a = (int8_t)(a >> 8);
   memcpy(dst, &pixel, sizeof pixel);
}

static INLINE void
util_format_pack_4ub(enum pipe_format format, void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a)
{
   void (*func)(void *dst, uint8_t r, uint8_t g, uint8_t b, uint8_t a);
   switch(format) {
   case PIPE_FORMAT_B8G8R8A8_UNORM:
      func = &util_format_b8g8r8a8_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_B8G8R8X8_UNORM:
      func = &util_format_b8g8r8x8_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_A8R8G8B8_UNORM:
      func = &util_format_a8r8g8b8_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_X8R8G8B8_UNORM:
      func = &util_format_x8r8g8b8_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_A8B8G8R8_UNORM:
      func = &util_format_a8b8g8r8_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_X8B8G8R8_UNORM:
      func = &util_format_x8b8g8r8_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_B5G5R5A1_UNORM:
      func = &util_format_b5g5r5a1_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_B4G4R4A4_UNORM:
      func = &util_format_b4g4r4a4_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_B5G6R5_UNORM:
      func = &util_format_b5g6r5_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_R10G10B10A2_UNORM:
      func = &util_format_r10g10b10a2_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_L8_UNORM:
      func = &util_format_l8_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_A8_UNORM:
      func = &util_format_a8_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_I8_UNORM:
      func = &util_format_i8_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_L8A8_UNORM:
      func = &util_format_l8a8_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_L16_UNORM:
      func = &util_format_l16_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_L8_SRGB:
      func = &util_format_l8_srgb_pack_4ub;
      break;
   case PIPE_FORMAT_L8A8_SRGB:
      func = &util_format_l8a8_srgb_pack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8_SRGB:
      func = &util_format_r8g8b8_srgb_pack_4ub;
      break;
   case PIPE_FORMAT_A8B8G8R8_SRGB:
      func = &util_format_a8b8g8r8_srgb_pack_4ub;
      break;
   case PIPE_FORMAT_X8B8G8R8_SRGB:
      func = &util_format_x8b8g8r8_srgb_pack_4ub;
      break;
   case PIPE_FORMAT_B8G8R8A8_SRGB:
      func = &util_format_b8g8r8a8_srgb_pack_4ub;
      break;
   case PIPE_FORMAT_B8G8R8X8_SRGB:
      func = &util_format_b8g8r8x8_srgb_pack_4ub;
      break;
   case PIPE_FORMAT_A8R8G8B8_SRGB:
      func = &util_format_a8r8g8b8_srgb_pack_4ub;
      break;
   case PIPE_FORMAT_X8R8G8B8_SRGB:
      func = &util_format_x8r8g8b8_srgb_pack_4ub;
      break;
   case PIPE_FORMAT_R8SG8SB8UX8U_NORM:
      func = &util_format_r8sg8sb8ux8u_norm_pack_4ub;
      break;
   case PIPE_FORMAT_R5SG5SB6U_NORM:
      func = &util_format_r5sg5sb6u_norm_pack_4ub;
      break;
   case PIPE_FORMAT_Z16_UNORM:
      func = &util_format_z16_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_Z32_UNORM:
      func = &util_format_z32_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_Z32_FLOAT:
      func = &util_format_z32_float_pack_4ub;
      break;
   case PIPE_FORMAT_Z24S8_UNORM:
      func = &util_format_z24s8_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_S8Z24_UNORM:
      func = &util_format_s8z24_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_Z24X8_UNORM:
      func = &util_format_z24x8_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_X8Z24_UNORM:
      func = &util_format_x8z24_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_R64_FLOAT:
      func = &util_format_r64_float_pack_4ub;
      break;
   case PIPE_FORMAT_R64G64_FLOAT:
      func = &util_format_r64g64_float_pack_4ub;
      break;
   case PIPE_FORMAT_R64G64B64_FLOAT:
      func = &util_format_r64g64b64_float_pack_4ub;
      break;
   case PIPE_FORMAT_R64G64B64A64_FLOAT:
      func = &util_format_r64g64b64a64_float_pack_4ub;
      break;
   case PIPE_FORMAT_R32_FLOAT:
      func = &util_format_r32_float_pack_4ub;
      break;
   case PIPE_FORMAT_R32G32_FLOAT:
      func = &util_format_r32g32_float_pack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32_FLOAT:
      func = &util_format_r32g32b32_float_pack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32A32_FLOAT:
      func = &util_format_r32g32b32a32_float_pack_4ub;
      break;
   case PIPE_FORMAT_R32_UNORM:
      func = &util_format_r32_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_R32G32_UNORM:
      func = &util_format_r32g32_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32_UNORM:
      func = &util_format_r32g32b32_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32A32_UNORM:
      func = &util_format_r32g32b32a32_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_R32_USCALED:
      func = &util_format_r32_uscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R32G32_USCALED:
      func = &util_format_r32g32_uscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32_USCALED:
      func = &util_format_r32g32b32_uscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32A32_USCALED:
      func = &util_format_r32g32b32a32_uscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R32_SNORM:
      func = &util_format_r32_snorm_pack_4ub;
      break;
   case PIPE_FORMAT_R32G32_SNORM:
      func = &util_format_r32g32_snorm_pack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32_SNORM:
      func = &util_format_r32g32b32_snorm_pack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32A32_SNORM:
      func = &util_format_r32g32b32a32_snorm_pack_4ub;
      break;
   case PIPE_FORMAT_R32_SSCALED:
      func = &util_format_r32_sscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R32G32_SSCALED:
      func = &util_format_r32g32_sscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32_SSCALED:
      func = &util_format_r32g32b32_sscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R32G32B32A32_SSCALED:
      func = &util_format_r32g32b32a32_sscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R16_UNORM:
      func = &util_format_r16_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_R16G16_UNORM:
      func = &util_format_r16g16_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_R16G16B16_UNORM:
      func = &util_format_r16g16b16_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_R16G16B16A16_UNORM:
      func = &util_format_r16g16b16a16_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_R16_USCALED:
      func = &util_format_r16_uscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R16G16_USCALED:
      func = &util_format_r16g16_uscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R16G16B16_USCALED:
      func = &util_format_r16g16b16_uscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R16G16B16A16_USCALED:
      func = &util_format_r16g16b16a16_uscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R16_SNORM:
      func = &util_format_r16_snorm_pack_4ub;
      break;
   case PIPE_FORMAT_R16G16_SNORM:
      func = &util_format_r16g16_snorm_pack_4ub;
      break;
   case PIPE_FORMAT_R16G16B16_SNORM:
      func = &util_format_r16g16b16_snorm_pack_4ub;
      break;
   case PIPE_FORMAT_R16G16B16A16_SNORM:
      func = &util_format_r16g16b16a16_snorm_pack_4ub;
      break;
   case PIPE_FORMAT_R16_SSCALED:
      func = &util_format_r16_sscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R16G16_SSCALED:
      func = &util_format_r16g16_sscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R16G16B16_SSCALED:
      func = &util_format_r16g16b16_sscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R16G16B16A16_SSCALED:
      func = &util_format_r16g16b16a16_sscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R8_UNORM:
      func = &util_format_r8_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_R8G8_UNORM:
      func = &util_format_r8g8_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8_UNORM:
      func = &util_format_r8g8b8_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8A8_UNORM:
      func = &util_format_r8g8b8a8_unorm_pack_4ub;
      break;
   case PIPE_FORMAT_R8_USCALED:
      func = &util_format_r8_uscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R8G8_USCALED:
      func = &util_format_r8g8_uscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8_USCALED:
      func = &util_format_r8g8b8_uscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8A8_USCALED:
      func = &util_format_r8g8b8a8_uscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R8_SNORM:
      func = &util_format_r8_snorm_pack_4ub;
      break;
   case PIPE_FORMAT_R8G8_SNORM:
      func = &util_format_r8g8_snorm_pack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8_SNORM:
      func = &util_format_r8g8b8_snorm_pack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8A8_SNORM:
      func = &util_format_r8g8b8a8_snorm_pack_4ub;
      break;
   case PIPE_FORMAT_R8_SSCALED:
      func = &util_format_r8_sscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R8G8_SSCALED:
      func = &util_format_r8g8_sscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8_SSCALED:
      func = &util_format_r8g8b8_sscaled_pack_4ub;
      break;
   case PIPE_FORMAT_R8G8B8A8_SSCALED:
      func = &util_format_r8g8b8a8_sscaled_pack_4ub;
      break;
   default:
      debug_printf("%s: unsupported format\n", __FUNCTION__);
      return;
   }
   func(dst, r, g, b, a);
}


#ifdef __cplusplus
}
#endif

#endif /* ! U_FORMAT_PACK_H */
